/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api.config;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigLimits;
import org.eclipse.milo.opcua.sdk.server.identity.AnonymousIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.server.config.UaTcpStackServerConfig;
import org.eclipse.milo.opcua.stack.server.config.UaTcpStackServerConfigBuilder;

public class OpcUaServerConfigBuilder
extends UaTcpStackServerConfigBuilder {
    private int bindPort = 12685;
    private List<String> bindAddresses = Lists.newArrayList((Object[])new String[]{"0.0.0.0"});
    private List<String> endpointAddresses = Lists.newArrayList((Object[])new String[]{HostnameUtil.getHostname()});
    private EnumSet<SecurityPolicy> securityPolicies = EnumSet.of(SecurityPolicy.None);
    private IdentityValidator identityValidator = AnonymousIdentityValidator.INSTANCE;
    private BuildInfo buildInfo = new BuildInfo("", "", "", "", "", DateTime.MIN_VALUE);
    private OpcUaServerConfigLimits limits = new OpcUaServerConfigLimits(){};

    public OpcUaServerConfigBuilder setBindPort(int bindPort) {
        this.bindPort = bindPort;
        return this;
    }

    public OpcUaServerConfigBuilder setBindAddresses(List<String> bindAddresses) {
        this.bindAddresses = bindAddresses;
        return this;
    }

    public OpcUaServerConfigBuilder setEndpointAddresses(List<String> endpointAddresses) {
        this.endpointAddresses = endpointAddresses;
        return this;
    }

    public OpcUaServerConfigBuilder setSecurityPolicies(EnumSet<SecurityPolicy> securityPolicies) {
        this.securityPolicies = securityPolicies;
        return this;
    }

    public OpcUaServerConfigBuilder setIdentityValidator(IdentityValidator identityValidator) {
        this.identityValidator = identityValidator;
        return this;
    }

    public OpcUaServerConfigBuilder setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
        return this;
    }

    public OpcUaServerConfigBuilder setLimits(OpcUaServerConfigLimits limits) {
        this.limits = limits;
        return this;
    }

    public OpcUaServerConfigBuilder setServerName(String serverName) {
        super.setServerName(serverName);
        return this;
    }

    public OpcUaServerConfigBuilder setApplicationName(LocalizedText applicationName) {
        super.setApplicationName(applicationName);
        return this;
    }

    public OpcUaServerConfigBuilder setApplicationUri(String applicationUri) {
        super.setApplicationUri(applicationUri);
        return this;
    }

    public OpcUaServerConfigBuilder setProductUri(String productUri) {
        super.setProductUri(productUri);
        return this;
    }

    public OpcUaServerConfigBuilder setCertificateManager(CertificateManager certificateManager) {
        super.setCertificateManager(certificateManager);
        return this;
    }

    public OpcUaServerConfigBuilder setCertificateValidator(CertificateValidator certificateValidator) {
        super.setCertificateValidator(certificateValidator);
        return this;
    }

    public OpcUaServerConfigBuilder setUserTokenPolicies(List<UserTokenPolicy> userTokenPolicies) {
        super.setUserTokenPolicies(userTokenPolicies);
        return this;
    }

    public OpcUaServerConfigBuilder setSoftwareCertificates(List<SignedSoftwareCertificate> softwareCertificates) {
        super.setSoftwareCertificates(softwareCertificates);
        return this;
    }

    public OpcUaServerConfigBuilder setExecutor(ExecutorService executor) {
        super.setExecutor(executor);
        return this;
    }

    public OpcUaServerConfigBuilder setChannelConfig(ChannelConfig channelConfig) {
        super.setChannelConfig(channelConfig);
        return this;
    }

    public OpcUaServerConfigBuilder setStrictEndpointUrlsEnabled(boolean strictEndpointUrlsEnforced) {
        super.setStrictEndpointUrlsEnabled(strictEndpointUrlsEnforced);
        return this;
    }

    public OpcUaServerConfig build() {
        UaTcpStackServerConfig stackServerConfig = super.build();
        return new OpcUaServerConfigImpl(stackServerConfig, this.bindPort, this.bindAddresses, this.endpointAddresses, this.securityPolicies, this.identityValidator, this.buildInfo, this.limits);
    }

    public static final class OpcUaServerConfigImpl
    implements OpcUaServerConfig {
        private final UaTcpStackServerConfig stackServerConfig;
        private final int bindPort;
        private final List<String> bindAddresses;
        private final List<String> endpointAddresses;
        private final EnumSet<SecurityPolicy> securityPolicies;
        private final IdentityValidator identityValidator;
        private final BuildInfo buildInfo;
        private final OpcUaServerConfigLimits limits;

        public OpcUaServerConfigImpl(UaTcpStackServerConfig stackServerConfig, int bindPort, List<String> bindAddresses, List<String> endpointAddresses, EnumSet<SecurityPolicy> securityPolicies, IdentityValidator identityValidator, BuildInfo buildInfo, OpcUaServerConfigLimits limits) {
            this.stackServerConfig = stackServerConfig;
            this.bindPort = bindPort;
            this.bindAddresses = bindAddresses;
            this.endpointAddresses = endpointAddresses;
            this.securityPolicies = securityPolicies;
            this.identityValidator = identityValidator;
            this.buildInfo = buildInfo;
            this.limits = limits;
        }

        @Override
        public int getBindPort() {
            return this.bindPort;
        }

        @Override
        public List<String> getBindAddresses() {
            return this.bindAddresses;
        }

        @Override
        public List<String> getEndpointAddresses() {
            return this.endpointAddresses;
        }

        @Override
        public IdentityValidator getIdentityValidator() {
            return this.identityValidator;
        }

        @Override
        public BuildInfo getBuildInfo() {
            return this.buildInfo;
        }

        @Override
        public OpcUaServerConfigLimits getLimits() {
            return this.limits;
        }

        @Override
        public EnumSet<SecurityPolicy> getSecurityPolicies() {
            return this.securityPolicies;
        }

        public String getServerName() {
            return this.stackServerConfig.getServerName();
        }

        public LocalizedText getApplicationName() {
            return this.stackServerConfig.getApplicationName();
        }

        public String getApplicationUri() {
            return this.stackServerConfig.getApplicationUri();
        }

        public String getProductUri() {
            return this.stackServerConfig.getProductUri();
        }

        public CertificateManager getCertificateManager() {
            return this.stackServerConfig.getCertificateManager();
        }

        public CertificateValidator getCertificateValidator() {
            return this.stackServerConfig.getCertificateValidator();
        }

        public ExecutorService getExecutor() {
            return this.stackServerConfig.getExecutor();
        }

        public List<UserTokenPolicy> getUserTokenPolicies() {
            return this.stackServerConfig.getUserTokenPolicies();
        }

        public List<SignedSoftwareCertificate> getSoftwareCertificates() {
            return this.stackServerConfig.getSoftwareCertificates();
        }

        public ChannelConfig getChannelConfig() {
            return this.stackServerConfig.getChannelConfig();
        }

        public boolean isStrictEndpointUrlsEnabled() {
            return this.stackServerConfig.isStrictEndpointUrlsEnabled();
        }
    }
}

