/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.milo.opcua.sdk.core.ServerTable;
import org.eclipse.milo.opcua.sdk.server.NamespaceManager;
import org.eclipse.milo.opcua.sdk.server.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.server.SessionManager;
import org.eclipse.milo.opcua.sdk.server.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.server.api.AbstractServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ObjectTypeManagerInitializer;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.VariableTypeManagerInitializer;
import org.eclipse.milo.opcua.sdk.server.namespaces.OpcUaNamespace;
import org.eclipse.milo.opcua.sdk.server.namespaces.VendorNamespace;
import org.eclipse.milo.opcua.sdk.server.services.helpers.BrowseHelper;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.stack.core.BuiltinReferenceType;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.ReferenceType;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.application.UaStackServer;
import org.eclipse.milo.opcua.stack.core.application.services.AttributeHistoryServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.AttributeServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.MethodServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.MonitoredItemServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.SessionServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.SubscriptionServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.ViewServiceSet;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.ManifestUtil;
import org.eclipse.milo.opcua.stack.server.config.UaTcpStackServerConfig;
import org.eclipse.milo.opcua.stack.server.tcp.UaTcpStackServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaServer {
    public static final String SDK_VERSION = ManifestUtil.read((String)"X-SDK-Version").orElse("dev");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ByteString, BrowseHelper.BrowseContinuationPoint> browseContinuationPoints = Maps.newConcurrentMap();
    private final ServerNodeMap nodeMap = new OpcUaServerNodeMap();
    private final Map<NodeId, ReferenceType> referenceTypes = Maps.newConcurrentMap();
    private final Map<UInteger, Subscription> subscriptions = Maps.newConcurrentMap();
    private final NamespaceManager namespaceManager = new NamespaceManager();
    private final SessionManager sessionManager = new SessionManager(this);
    private final ServerTable serverTable = new ServerTable();
    private final ObjectTypeManager objectTypeManager = new ObjectTypeManager();
    private final VariableTypeManager variableTypeManager = new VariableTypeManager();
    private final UaTcpStackServer discoveryServer;
    private final UaTcpStackServer stackServer;
    private final EventBus eventBus;
    private final OpcUaNamespace uaNamespace;
    private final VendorNamespace vendorNamespace;
    private final OpcUaServerConfig config;

    public OpcUaServer(OpcUaServerConfig config) {
        this.config = config;
        this.discoveryServer = new UaTcpStackServer((UaTcpStackServerConfig)OpcUaServerConfig.copy(config, b -> {
            String serverName = config.getServerName();
            String discoveryServerName = "discovery";
            if (!serverName.isEmpty()) {
                discoveryServerName = serverName.endsWith("/") ? serverName + discoveryServerName : serverName + "/" + discoveryServerName;
            }
            b.setServerName(discoveryServerName);
        }));
        this.stackServer = new UaTcpStackServer((UaTcpStackServerConfig)config);
        this.stackServer.addServiceSet((AttributeServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((AttributeHistoryServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((MethodServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((MonitoredItemServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((NodeManagementServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((SessionServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((SubscriptionServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((ViewServiceSet)this.sessionManager);
        ObjectTypeManagerInitializer.initialize(this.objectTypeManager);
        VariableTypeManagerInitializer.initialize(this.variableTypeManager);
        this.uaNamespace = new OpcUaNamespace(this);
        this.namespaceManager.addNamespace(this.uaNamespace);
        this.vendorNamespace = this.namespaceManager.registerAndAdd(config.getApplicationUri(), index -> new VendorNamespace(this, config.getApplicationUri()));
        this.serverTable.addUri(this.stackServer.getApplicationDescription().getApplicationUri());
        for (BuiltinReferenceType referenceType : BuiltinReferenceType.values()) {
            this.referenceTypes.put(referenceType.getNodeId(), (ReferenceType)referenceType);
        }
        for (String bindAddress : config.getBindAddresses()) {
            HashSet hostnames = Sets.newHashSet(config.getEndpointAddresses());
            for (String hostname : hostnames) {
                String endpointUrl = OpcUaServer.endpointUrl(hostname, config.getBindPort(), config.getServerName());
                for (SecurityPolicy securityPolicy : config.getSecurityPolicies()) {
                    MessageSecurityMode messageSecurity = securityPolicy == SecurityPolicy.None ? MessageSecurityMode.None : MessageSecurityMode.SignAndEncrypt;
                    Set certificates = config.getCertificateManager().getCertificates();
                    if (certificates.isEmpty()) {
                        this.logger.info("Binding endpoint {} to {} [{}/{}]", new Object[]{endpointUrl, bindAddress, securityPolicy, messageSecurity});
                        this.stackServer.addEndpoint(endpointUrl, bindAddress, null, securityPolicy, messageSecurity);
                        this.discoveryServer.addEndpoint(endpointUrl, bindAddress, null, securityPolicy, messageSecurity);
                        continue;
                    }
                    for (X509Certificate certificate : certificates) {
                        this.logger.info("Binding endpoint {} to {} [{}/{}]", new Object[]{endpointUrl, bindAddress, securityPolicy, messageSecurity});
                        this.stackServer.addEndpoint(endpointUrl, bindAddress, certificate, securityPolicy, messageSecurity);
                        this.discoveryServer.addEndpoint(endpointUrl, bindAddress, certificate, securityPolicy, messageSecurity);
                    }
                }
                String discoveryUrl = OpcUaServer.endpointUrl(hostname, config.getBindPort(), this.discoveryServer.getConfig().getServerName());
                this.discoveryServer.addEndpoint(discoveryUrl, bindAddress, null, SecurityPolicy.None, MessageSecurityMode.None);
            }
        }
        this.eventBus = new AsyncEventBus("server", (Executor)this.stackServer.getExecutorService());
    }

    public CompletableFuture<OpcUaServer> startup() {
        return ((CompletableFuture)((CompletableFuture)this.discoveryServer.startup().exceptionally(ex -> {
            this.logger.warn("failed to start discoveryServer", ex);
            return null;
        })).thenRun(() -> ((UaTcpStackServer)this.stackServer).startup())).thenApply(v -> this);
    }

    public CompletableFuture<OpcUaServer> shutdown() {
        return ((CompletableFuture)((CompletableFuture)this.discoveryServer.shutdown().exceptionally(ex -> {
            this.logger.warn("failed to shutdown discoveryServer", ex);
            return null;
        })).thenRun(() -> ((UaTcpStackServer)this.stackServer).shutdown())).thenApply(v -> this);
    }

    private static String endpointUrl(String hostname, int port, String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("opc.tcp://%s:%d", hostname, port));
        if (!serverName.isEmpty()) {
            sb.append("/").append(serverName);
        }
        return sb.toString();
    }

    public OpcUaServerConfig getConfig() {
        return this.config;
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public ServerNodeMap getNodeMap() {
        return this.nodeMap;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public OpcUaNamespace getUaNamespace() {
        return this.uaNamespace;
    }

    public ServerTable getServerTable() {
        return this.serverTable;
    }

    public ObjectTypeManager getObjectTypeManager() {
        return this.objectTypeManager;
    }

    public VariableTypeManager getVariableTypeManager() {
        return this.variableTypeManager;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public Map<UInteger, Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public Optional<KeyPair> getKeyPair(ByteString thumbprint) {
        return this.stackServer.getCertificateManager().getKeyPair(thumbprint);
    }

    public Optional<X509Certificate> getCertificate(ByteString thumbprint) {
        return this.stackServer.getCertificateManager().getCertificate(thumbprint);
    }

    public Optional<X509Certificate[]> getCertificateChain(ByteString thumbprint) {
        return this.stackServer.getCertificateManager().getCertificateChain(thumbprint);
    }

    public ExecutorService getExecutorService() {
        return this.stackServer.getExecutorService();
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return Stack.sharedScheduledExecutor();
    }

    public ChannelConfig getChannelConfig() {
        return this.stackServer.getChannelConfig();
    }

    public EndpointDescription[] getEndpointDescriptions() {
        return this.stackServer.getEndpointDescriptions();
    }

    public List<UserTokenPolicy> getUserTokenPolicies() {
        return this.stackServer.getUserTokenPolicies();
    }

    public ApplicationDescription getApplicationDescription() {
        return this.stackServer.getApplicationDescription();
    }

    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        return this.stackServer.getSoftwareCertificates();
    }

    public void closeSecureChannel(ServerSecureChannel secureChannel) {
        this.stackServer.closeSecureChannel(secureChannel);
    }

    public UaStackServer getServer() {
        return this.stackServer;
    }

    public Map<NodeId, ReferenceType> getReferenceTypes() {
        return this.referenceTypes;
    }

    public Map<ByteString, BrowseHelper.BrowseContinuationPoint> getBrowseContinuationPoints() {
        return this.browseContinuationPoints;
    }

    static {
        Logger logger = LoggerFactory.getLogger(OpcUaServer.class);
        logger.info("Eclipse Milo OPC UA Stack version: {}", (Object)Stack.VERSION);
        logger.info("Eclipse Milo OPC UA Server SDK version: {}", (Object)SDK_VERSION);
    }

    private class OpcUaServerNodeMap
    extends AbstractServerNodeMap {
        private OpcUaServerNodeMap() {
        }

        @Override
        public NamespaceTable getNamespaceTable() {
            return OpcUaServer.this.namespaceManager.getNamespaceTable();
        }
    }
}

