/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class PathMatchers {
    public static Matcher<Path> exists() {
        return new PathPredicate(x$0 -> Files.exists(x$0, new LinkOption[0]), "path should exist");
    }

    public static Matcher<Path> isRegularFile() {
        return new PathPredicate(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]), "path is regular file", p -> {
            if (!Files.exists(p, new LinkOption[0])) {
                return " path does not exist";
            }
            if (Files.isDirectory(p, new LinkOption[0])) {
                return " path is a directory";
            }
            if (Files.isSymbolicLink(p)) {
                return " path is a symlink";
            }
            return " path type is unknown";
        });
    }

    public static Matcher<Path> isDirectory() {
        return new PathPredicate(x$0 -> Files.isDirectory(x$0, new LinkOption[0]), "path is directory", p -> {
            if (!Files.exists(p, new LinkOption[0])) {
                return " path does not exist";
            }
            if (Files.isRegularFile(p, new LinkOption[0])) {
                return " path is a file";
            }
            if (Files.isSymbolicLink(p)) {
                return " path is a symlink";
            }
            return " path type is unknown";
        });
    }

    public static Matcher<Path> isEmptyDirectory() {
        return new PathPredicate(p -> {
            boolean bl;
            block10: {
                if (!Files.exists(p, new LinkOption[0])) {
                    return false;
                }
                if (!Files.isDirectory(p, new LinkOption[0])) {
                    return false;
                }
                Stream<Path> listStream = Files.list(p);
                try {
                    long count = listStream.count();
                    boolean bl2 = bl = count == 0L;
                    if (listStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (listStream != null) {
                            try {
                                listStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                listStream.close();
            }
            return bl;
        }, "path is directory", p -> {
            String string;
            block10: {
                if (!Files.exists(p, new LinkOption[0])) {
                    return " path does not exist";
                }
                if (!Files.isDirectory(p, new LinkOption[0])) {
                    return " path is not a directory";
                }
                Stream<Path> listStream = Files.list(p);
                try {
                    long count = listStream.count();
                    string = String.format(" path has %,d entries", count);
                    if (listStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (listStream != null) {
                            try {
                                listStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return String.format(" error reading file list: (%s) %s", e.getClass().getName(), e.getMessage());
                    }
                }
                listStream.close();
            }
            return string;
        });
    }

    public static Matcher<Path> isSame(Path expected) {
        return new PathPredicate(p -> {
            try {
                return Files.isSameFile(p, expected);
            }
            catch (IOException e) {
                return false;
            }
        }, "path is same", p -> String.format(" is not same as <%s>", expected.toString()));
    }

    private static class PathPredicate
    extends TypeSafeMatcher<Path> {
        private final Predicate<Path> pathPredicate;
        private final String expectationText;
        private Function<Path, String> describeFailure;

        private PathPredicate(Predicate<Path> pathPredicate, String expectationText) {
            this(pathPredicate, expectationText, null);
        }

        private PathPredicate(Predicate<Path> pathPredicate, String expectationText, Function<Path, String> describeFailure) {
            this.pathPredicate = Objects.requireNonNull(pathPredicate);
            this.expectationText = Objects.requireNonNull(expectationText);
            this.describeFailure = describeFailure;
        }

        public void describeTo(Description description) {
            description.appendText(this.expectationText);
        }

        protected boolean matchesSafely(Path item) {
            return this.pathPredicate.test(item);
        }

        protected void describeMismatchSafely(Path item, Description mismatchDescription) {
            String butSuffix;
            mismatchDescription.appendValue((Object)item);
            if (this.describeFailure != null && (butSuffix = this.describeFailure.apply(item)) != null) {
                mismatchDescription.appendText(butSuffix);
            }
        }
    }
}

