/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;

public class CombinedResource
extends Resource {
    private final List<Resource> _resources;

    static Resource combine(List<Resource> resources) {
        if ((resources = CombinedResource.gatherUniqueFlatResourceList(resources)) == null || resources.isEmpty()) {
            return null;
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        return new CombinedResource(resources);
    }

    static List<Resource> gatherUniqueFlatResourceList(List<Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        ArrayList<Resource> unique = new ArrayList<Resource>(resources.size());
        for (Resource r : resources) {
            if (r == null) {
                throw new IllegalArgumentException("Null Resource entry encountered");
            }
            if (r instanceof CombinedResource) {
                CombinedResource resourceCollection = (CombinedResource)r;
                unique.addAll(CombinedResource.gatherUniqueFlatResourceList(resourceCollection.getResources()));
                continue;
            }
            if (unique.contains(r)) continue;
            if (!r.exists()) {
                throw new IllegalArgumentException("Does not exist: " + String.valueOf(r));
            }
            if (!r.isDirectory()) {
                throw new IllegalArgumentException("Non-Directory not allowed: " + String.valueOf(r));
            }
            unique.add(r);
        }
        return unique;
    }

    CombinedResource(List<Resource> resources) {
        this._resources = Collections.unmodifiableList(resources);
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    @Override
    public Resource resolve(String subUriPath) {
        if (URIUtil.isNotNormalWithinSelf(subUriPath)) {
            throw new IllegalArgumentException(subUriPath);
        }
        if (subUriPath.length() == 0 || "/".equals(subUriPath)) {
            return this;
        }
        ArrayList<Resource> resources = null;
        Resource resolved = null;
        for (Resource res : this._resources) {
            resolved = res.resolve(subUriPath);
            if (Resources.missing(resolved)) continue;
            if (!resolved.isDirectory()) {
                return resolved;
            }
            if (resources == null) {
                resources = new ArrayList<Resource>();
            }
            resources.add(resolved);
        }
        if (resources == null) {
            return resolved;
        }
        if (resources.size() == 1) {
            return (Resource)resources.get(0);
        }
        return new CombinedResource((List<Resource>)resources);
    }

    @Override
    public boolean exists() {
        return this._resources.stream().anyMatch(Resource::exists);
    }

    @Override
    public Path getPath() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getFileName() {
        String filename = null;
        for (Resource r : this._resources) {
            String fn = r.getFileName();
            if (fn == null) {
                return null;
            }
            if (filename == null) {
                filename = fn;
                continue;
            }
            if (filename.equals(fn)) continue;
            return null;
        }
        return filename;
    }

    @Override
    public URI getURI() {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isReadable() {
        for (Resource r : this._resources) {
            if (!r.isReadable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Instant lastModified() {
        Instant instant = null;
        for (Resource r : this._resources) {
            Instant lm = r.lastModified();
            if (instant != null && !lm.isAfter(instant)) continue;
            instant = lm;
        }
        return instant;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public Iterator<Resource> iterator() {
        return this._resources.iterator();
    }

    @Override
    public List<Resource> list() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : this._resources) {
            if (r.isDirectory()) {
                result.addAll(r.list());
                continue;
            }
            result.add(r);
        }
        return result;
    }

    @Override
    public void copyTo(Path destination) throws IOException {
        int r = this._resources.size();
        while (r-- > 0) {
            this._resources.get(r).copyTo(destination);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedResource other = (CombinedResource)o;
        return Objects.equals(this._resources, other._resources);
    }

    public int hashCode() {
        return Objects.hash(this._resources);
    }

    public String toString() {
        return this._resources.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public boolean isContainedIn(Resource r) {
        return false;
    }
}

