/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.AbstractSessionCache;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionData;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class DefaultSessionCache
extends AbstractSessionCache {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSessionCache.class);
    private final ConcurrentMap<String, ManagedSession> _sessions;
    private final CounterStatistic _stats = new CounterStatistic();

    public DefaultSessionCache(SessionManager manager) {
        this(manager, new ConcurrentHashMap<String, ManagedSession>());
    }

    public DefaultSessionCache(SessionManager manager, ConcurrentMap<String, ManagedSession> sessions) {
        super(manager);
        this._sessions = Objects.requireNonNull(sessions, "Session Map may not be null");
    }

    @ManagedAttribute(value="current sessions in cache", readonly=true)
    public long getSessionsCurrent() {
        return this._stats.getCurrent();
    }

    @ManagedAttribute(value="max sessions in cache", readonly=true)
    public long getSessionsMax() {
        return this._stats.getMax();
    }

    @ManagedAttribute(value="total sessions in cache", readonly=true)
    public long getSessionsTotal() {
        return this._stats.getTotal();
    }

    @ManagedOperation(value="reset statistics", impact="ACTION")
    public void resetStats() {
        this._stats.reset();
    }

    @Override
    public ManagedSession doGet(String id) {
        if (id == null) {
            return null;
        }
        return (ManagedSession)this._sessions.get(id);
    }

    @Override
    public Session doPutIfAbsent(String id, ManagedSession session) {
        Session s = this._sessions.putIfAbsent(id, session);
        if (s == null) {
            this._stats.increment();
        }
        return s;
    }

    @Override
    protected ManagedSession doComputeIfAbsent(String id, Function<String, ManagedSession> mappingFunction) {
        return this._sessions.computeIfAbsent(id, k -> {
            ManagedSession s = (ManagedSession)mappingFunction.apply((String)k);
            if (s != null) {
                this._stats.increment();
            }
            return s;
        });
    }

    @Override
    public ManagedSession doDelete(String id) {
        ManagedSession s = (ManagedSession)this._sessions.remove(id);
        if (s != null) {
            this._stats.decrement();
        }
        return s;
    }

    @Override
    public void shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutdown sessions, invalidating = {}", (Object)this.isInvalidateOnShutdown());
        }
        int loop = 100;
        while (!this._sessions.isEmpty() && loop-- > 0) {
            for (ManagedSession session : this._sessions.values()) {
                if (this.isInvalidateOnShutdown()) {
                    try {
                        session.invalidate();
                    }
                    catch (Exception e) {
                        LOG.trace("IGNORED", (Throwable)e);
                    }
                    continue;
                }
                if (this._sessionDataStore.isPassivating()) {
                    session.willPassivate();
                }
                try {
                    this._sessionDataStore.store(session.getId(), session.getSessionData());
                }
                catch (Exception e) {
                    LOG.warn("Unable to store {}", (Object)session, (Object)e);
                }
                this.doDelete(session.getId());
                session.setResident(false);
            }
        }
    }

    @Override
    public ManagedSession newSession(SessionData data) {
        ManagedSession session = new ManagedSession(this.getSessionManager(), data);
        return session;
    }

    @Override
    public boolean doReplace(String id, ManagedSession oldValue, ManagedSession newValue) {
        return this._sessions.replace(id, oldValue, newValue);
    }
}

