/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpInput
extends ServletInputStream
implements Runnable {
    private static final Logger LOG = Log.getLogger(HttpInput.class);
    private static final Content EOF_CONTENT = new EofContent("EOF");
    private static final Content EARLY_EOF_CONTENT = new EofContent("EARLY_EOF");
    private final byte[] _oneByteBuffer = new byte[1];
    private final ArrayQueue<Content> _inputQ = new ArrayQueue();
    private final HttpChannelState _channelState;
    private ReadListener _listener;
    private State _state = STREAM;
    private long _contentConsumed;
    protected static final State STREAM = new State(){

        @Override
        public boolean blockForContent(HttpInput input) throws IOException {
            input.blockForContent();
            return true;
        }

        public String toString() {
            return "STREAM";
        }
    };
    protected static final State ASYNC = new State(){

        @Override
        public int noContent() throws IOException {
            return 0;
        }

        public String toString() {
            return "ASYNC";
        }
    };
    protected static final State EARLY_EOF = new EOFState(){

        @Override
        public int noContent() throws IOException {
            throw new EofException("Early EOF");
        }

        public String toString() {
            return "EARLY_EOF";
        }
    };
    protected static final State EOF = new EOFState(){

        public String toString() {
            return "EOF";
        }
    };
    protected static final State AEOF = new EOFState(){

        public String toString() {
            return "AEOF";
        }
    };

    public HttpInput(HttpChannelState state) {
        this._channelState = state;
    }

    protected HttpChannelState getHttpChannelState() {
        return this._channelState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            Content item = (Content)((Object)this._inputQ.pollUnsafe());
            while (item != null) {
                item.failed(null);
                item = (Content)((Object)this._inputQ.pollUnsafe());
            }
            this._listener = null;
            this._state = STREAM;
            this._contentConsumed = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        int available = 0;
        boolean woken = false;
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            Content content = (Content)((Object)this._inputQ.peekUnsafe());
            if (content == null) {
                try {
                    this.produceContent();
                }
                catch (IOException e) {
                    woken = this.failed(e);
                }
                content = (Content)((Object)this._inputQ.peekUnsafe());
            }
            if (content != null) {
                available = this.remaining(content);
            }
        }
        if (woken) {
            this.wake();
        }
        return available;
    }

    private void wake() {
        this._channelState.getHttpChannel().getConnector().getExecutor().execute(this._channelState.getHttpChannel());
    }

    public int read() throws IOException {
        int read = this.read(this._oneByteBuffer, 0, 1);
        if (read == 0) {
            throw new IllegalStateException("unready read=0");
        }
        return read < 0 ? -1 : this._oneByteBuffer[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            do {
                Content item;
                if ((item = this.nextContent()) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} read {} from {}", new Object[]{this, len, item});
                }
                int l = this.get(item, b, off, len);
                this.consumeNonContent();
                return l;
            } while (this._state.blockForContent(this));
            return this._state.noContent();
        }
    }

    protected void produceContent() throws IOException {
    }

    protected Content nextContent() throws IOException {
        Content content = this.pollContent();
        if (content == null && !this.isFinished()) {
            this.produceContent();
            content = this.pollContent();
        }
        return content;
    }

    protected Content pollContent() {
        Content content = (Content)((Object)this._inputQ.peekUnsafe());
        while (content != null && this.remaining(content) == 0) {
            this._inputQ.pollUnsafe();
            content.succeeded();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} consumed {}", new Object[]{this, content});
            }
            if (content == EOF_CONTENT) {
                if (this._listener == null) {
                    this._state = EOF;
                } else {
                    this._state = AEOF;
                    boolean woken = this._channelState.onReadReady();
                    if (woken) {
                        this.wake();
                    }
                }
            } else if (content == EARLY_EOF_CONTENT) {
                this._state = EARLY_EOF;
            }
            content = (Content)((Object)this._inputQ.peekUnsafe());
        }
        return content;
    }

    protected void consumeNonContent() {
        Content content = (Content)((Object)this._inputQ.peekUnsafe());
        while (content != null && this.remaining(content) == 0 && !(content instanceof EofContent)) {
            this._inputQ.pollUnsafe();
            content.succeeded();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} consumed {}", new Object[]{this, content});
            }
            content = (Content)((Object)this._inputQ.peekUnsafe());
        }
    }

    protected Content nextReadable() throws IOException {
        Content content = this.pollReadable();
        if (content == null && !this.isFinished()) {
            this.produceContent();
            content = this.pollReadable();
        }
        return content;
    }

    protected Content pollReadable() {
        Content content = (Content)((Object)this._inputQ.peekUnsafe());
        while (content != null) {
            if (content == EOF_CONTENT || content == EARLY_EOF_CONTENT || this.remaining(content) > 0) {
                return content;
            }
            this._inputQ.pollUnsafe();
            content.succeeded();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} consumed {}", new Object[]{this, content});
            }
            content = (Content)((Object)this._inputQ.peekUnsafe());
        }
        return content;
    }

    protected int remaining(Content item) {
        return item.remaining();
    }

    protected int get(Content content, byte[] buffer, int offset, int length) {
        int l = Math.min(content.remaining(), length);
        content.getContent().get(buffer, offset, l);
        this._contentConsumed += (long)l;
        return l;
    }

    protected void skip(Content content, int length) {
        int l = Math.min(content.remaining(), length);
        ByteBuffer buffer = content.getContent();
        buffer.position(buffer.position() + l);
        this._contentConsumed += (long)l;
        if (l > 0 && !content.hasContent()) {
            this.pollContent();
        }
    }

    protected void blockForContent() throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} blocking for content...", new Object[]{this});
            }
            this._inputQ.wait();
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addContent(Content item) {
        boolean woken = false;
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            this._inputQ.addUnsafe((Object)item);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} addContent {}", new Object[]{this, item});
            }
            if (this._listener == null) {
                this._inputQ.notify();
            } else {
                woken = this._channelState.onReadPossible();
            }
        }
        return woken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasContent() {
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            return this._inputQ.sizeUnsafe() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            this._inputQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentConsumed() {
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            return this._contentConsumed;
        }
    }

    public boolean earlyEOF() {
        return this.addContent(EARLY_EOF_CONTENT);
    }

    public boolean eof() {
        return this.addContent(EOF_CONTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consumeAll() {
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            try {
                Content item;
                while (!this.isFinished() && (item = this.nextContent()) != null) {
                    this.skip(item, this.remaining(item));
                }
                return this.isFinished() && !this.isError();
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isError() {
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            return this._state instanceof ErrorState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            return this._state == ASYNC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            return this._state instanceof EOFState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        try {
            ArrayQueue<Content> arrayQueue = this._inputQ;
            synchronized (arrayQueue) {
                if (this._listener == null) {
                    return true;
                }
                if (this._state instanceof EOFState) {
                    return true;
                }
                if (this.nextReadable() != null) {
                    return true;
                }
                this._channelState.onReadUnready();
            }
            return false;
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadListener(ReadListener readListener) {
        readListener = Objects.requireNonNull(readListener);
        boolean woken = false;
        try {
            ArrayQueue<Content> arrayQueue = this._inputQ;
            synchronized (arrayQueue) {
                boolean content;
                if (this._listener != null) {
                    throw new IllegalStateException("ReadListener already set");
                }
                if (this._state != STREAM) {
                    throw new IllegalStateException("State " + STREAM + " != " + this._state);
                }
                this._state = ASYNC;
                this._listener = readListener;
                boolean bl = content = this.nextContent() != null;
                if (content) {
                    woken = this._channelState.onReadReady();
                } else {
                    this._channelState.onReadUnready();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        if (woken) {
            this.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failed(Throwable x) {
        boolean woken = false;
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            if (this._state instanceof ErrorState) {
                LOG.warn(x);
            } else {
                this._state = new ErrorState(x);
            }
            if (this._listener == null) {
                this._inputQ.notify();
            } else {
                woken = this._channelState.onReadPossible();
            }
        }
        return woken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable error;
        ReadListener listener;
        boolean aeof = false;
        ArrayQueue<Content> arrayQueue = this._inputQ;
        synchronized (arrayQueue) {
            if (this._state == EOF) {
                return;
            }
            if (this._state == AEOF) {
                this._state = EOF;
                aeof = true;
            }
            listener = this._listener;
            error = this._state instanceof ErrorState ? ((ErrorState)this._state).getError() : null;
        }
        try {
            if (error != null) {
                this._channelState.getHttpChannel().getResponse().getHttpFields().add(HttpConnection.CONNECTION_CLOSE);
                listener.onError(error);
            } else if (aeof) {
                listener.onAllDataRead();
            } else if (error == null) {
                listener.onDataAvailable();
            }
        }
        catch (Throwable e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
            try {
                if (aeof || error == null) {
                    this._channelState.getHttpChannel().getResponse().getHttpFields().add(HttpConnection.CONNECTION_CLOSE);
                    listener.onError(e);
                }
            }
            catch (Throwable e2) {
                LOG.warn(e2.toString(), new Object[0]);
                LOG.debug(e2);
                throw new RuntimeIOException(e2);
            }
        }
    }

    protected class ErrorState
    extends EOFState {
        final Throwable _error;

        ErrorState(Throwable error) {
            this._error = error;
        }

        public Throwable getError() {
            return this._error;
        }

        @Override
        public int noContent() throws IOException {
            if (this._error instanceof IOException) {
                throw (IOException)this._error;
            }
            throw new IOException(this._error);
        }

        public String toString() {
            return "ERROR:" + this._error;
        }
    }

    protected static class EOFState
    extends State {
        protected EOFState() {
        }
    }

    protected static abstract class State {
        protected State() {
        }

        public boolean blockForContent(HttpInput in) throws IOException {
            return false;
        }

        public int noContent() throws IOException {
            return -1;
        }
    }

    public static class Content
    extends Callback.Adapter {
        private final ByteBuffer _content;

        public Content(ByteBuffer content) {
            this._content = content;
        }

        public ByteBuffer getContent() {
            return this._content;
        }

        public boolean hasContent() {
            return this._content.hasRemaining();
        }

        public int remaining() {
            return this._content.remaining();
        }

        public String toString() {
            return String.format("Content@%x{%s}", ((Object)((Object)this)).hashCode(), BufferUtil.toDetailString((ByteBuffer)this._content));
        }
    }

    public static class EofContent
    extends PoisonPillContent {
        EofContent(String name) {
            super(name);
        }
    }

    public static class PoisonPillContent
    extends Content {
        private final String _name;

        public PoisonPillContent(String name) {
            super(BufferUtil.EMPTY_BUFFER);
            this._name = name;
        }

        @Override
        public String toString() {
            return this._name;
        }
    }
}

