/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.AsyncContinuation;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class StatisticsHandler
extends HandlerWrapper {
    private final transient AtomicLong _statsStartedAt = new AtomicLong();
    private final transient AtomicInteger _requests = new AtomicInteger();
    private final transient AtomicInteger _resumedRequests = new AtomicInteger();
    private final transient AtomicInteger _expiredRequests = new AtomicInteger();
    private final transient AtomicLong _requestMinTime = new AtomicLong();
    private final transient AtomicLong _requestMaxTime = new AtomicLong();
    private final transient AtomicLong _requestTotalTime = new AtomicLong();
    private final transient AtomicLong _suspendMinTime = new AtomicLong();
    private final transient AtomicLong _suspendTotalTime = new AtomicLong();
    private final transient AtomicInteger _requestsActive = new AtomicInteger();
    private final transient AtomicInteger _requestsMaxActive = new AtomicInteger();
    private final transient AtomicInteger _responses1xx = new AtomicInteger();
    private final transient AtomicInteger _responses2xx = new AtomicInteger();
    private final transient AtomicInteger _responses3xx = new AtomicInteger();
    private final transient AtomicInteger _responses4xx = new AtomicInteger();
    private final transient AtomicInteger _responses5xx = new AtomicInteger();
    private final transient AtomicLong _responsesTotalBytes = new AtomicLong();

    public void statsReset() {
        this._statsStartedAt.set(System.currentTimeMillis());
        this._requests.set(0);
        this._resumedRequests.set(0);
        this._expiredRequests.set(0);
        this._requestMinTime.set(Long.MAX_VALUE);
        this._requestMaxTime.set(0L);
        this._requestTotalTime.set(0L);
        this._suspendMinTime.set(Long.MAX_VALUE);
        this._suspendTotalTime.set(0L);
        this._requestsActive.set(0);
        this._requestsMaxActive.set(0);
        this._responses1xx.set(0);
        this._responses2xx.set(0);
        this._responses3xx.set(0);
        this._responses4xx.set(0);
        this._responses5xx.set(0);
        this._responsesTotalBytes.set(0L);
    }

    private void updateMax(AtomicInteger valueHolder, int value) {
        int oldValue = valueHolder.get();
        while (value > oldValue && !valueHolder.compareAndSet(oldValue, value)) {
            oldValue = valueHolder.get();
        }
    }

    private void updateMax(AtomicLong valueHolder, long value) {
        long oldValue = valueHolder.get();
        while (value > oldValue && !valueHolder.compareAndSet(oldValue, value)) {
            oldValue = valueHolder.get();
        }
    }

    private void updateMin(AtomicLong valueHolder, long value) {
        long oldValue = valueHolder.get();
        while (value < oldValue && !valueHolder.compareAndSet(oldValue, value)) {
            oldValue = valueHolder.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        this._requests.incrementAndGet();
        int activeRequests = this._requestsActive.incrementAndGet();
        this.updateMax(this._requestsMaxActive, activeRequests);
        AsyncContinuation continuation = request.getAsyncContinuation();
        if (continuation.isExpired()) {
            this._expiredRequests.incrementAndGet();
        } else if (continuation.isResumed()) {
            this._resumedRequests.incrementAndGet();
            long initialTime = request.getTimeStamp();
            long suspendTime = System.currentTimeMillis() - initialTime;
            this.updateMin(this._suspendMinTime, suspendTime);
            this._suspendTotalTime.addAndGet(suspendTime);
        }
        try {
            super.handle(path, request, httpRequest, httpResponse);
            Object var12_9 = null;
            this._requestsActive.decrementAndGet();
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            this._requestsActive.decrementAndGet();
            if (!continuation.isSuspended()) {
                this.updateResponse(request);
            }
            throw throwable;
        }
        if (!continuation.isSuspended()) {
            this.updateResponse(request);
        }
    }

    private void updateResponse(Request request) {
        long elapsed = System.currentTimeMillis() - request.getTimeStamp();
        this.updateMin(this._requestMinTime, elapsed);
        this.updateMax(this._requestMaxTime, elapsed);
        this._requestTotalTime.addAndGet(elapsed);
        Response response = request.getResponse();
        switch (response.getStatus() / 100) {
            case 1: {
                this._responses1xx.incrementAndGet();
                break;
            }
            case 2: {
                this._responses2xx.incrementAndGet();
                break;
            }
            case 3: {
                this._responses3xx.incrementAndGet();
                break;
            }
            case 4: {
                this._responses4xx.incrementAndGet();
                break;
            }
            case 5: {
                this._responses5xx.incrementAndGet();
                break;
            }
        }
        this._responsesTotalBytes.addAndGet(response.getContentCount());
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.statsReset();
    }

    public int getRequests() {
        return this._requests.get();
    }

    public int getRequestsActive() {
        return this._requestsActive.get();
    }

    public int getRequestsActiveMax() {
        return this._requestsMaxActive.get();
    }

    public int getRequestsResumed() {
        return this._resumedRequests.get();
    }

    public int getRequestsExpired() {
        return this._expiredRequests.get();
    }

    public int getResponses1xx() {
        return this._responses1xx.get();
    }

    public int getResponses2xx() {
        return this._responses2xx.get();
    }

    public int getResponses3xx() {
        return this._responses3xx.get();
    }

    public int getResponses4xx() {
        return this._responses4xx.get();
    }

    public int getResponses5xx() {
        return this._responses5xx.get();
    }

    public long getStatsOnMs() {
        return System.currentTimeMillis() - this._statsStartedAt.get();
    }

    public long getRequestTimeMin() {
        return this._requestMinTime.get();
    }

    public long getRequestTimeMax() {
        return this._requestMaxTime.get();
    }

    public long getRequestTimeTotal() {
        return this._requestTotalTime.get();
    }

    public long getRequestTimeAverage() {
        int requests = this.getRequests();
        return requests == 0 ? 0L : this.getRequestTimeTotal() / (long)requests;
    }

    public long getResponsesBytesTotal() {
        return this._responsesTotalBytes.get();
    }

    public long getSuspendedTimeMin() {
        return this._suspendMinTime.get();
    }

    public long getSuspendedTimeTotal() {
        return this._suspendTotalTime.get();
    }
}

