/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.ArrayDeque;
import java.util.Queue;
import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedSinglePublisher<T>
extends AbstractSinglePublisher<T> {
    public static final Terminal COMPLETE = Subscriber::onComplete;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Queue<Object> items = new ArrayDeque<Object>();
    private long demand;
    private boolean stalled = true;

    public void offer(T item) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("offered item {} to {}", item, (Object)this);
        }
        this.process(item);
    }

    public boolean complete() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("completed {}", (Object)this);
        }
        return this.process(COMPLETE);
    }

    public boolean fail(Throwable failure) {
        return this.process(new Failure(failure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRequest(Subscriber<? super T> subscriber, long n) {
        boolean proceed = false;
        QueuedSinglePublisher queuedSinglePublisher = this;
        synchronized (queuedSinglePublisher) {
            this.demand = QueuedSinglePublisher.cappedAdd(this.demand, n);
            if (this.stalled) {
                this.stalled = false;
                proceed = true;
            }
        }
        if (proceed) {
            this.proceed(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process(Object item) {
        Subscriber subscriber;
        QueuedSinglePublisher queuedSinglePublisher = this;
        synchronized (queuedSinglePublisher) {
            this.items.offer(item);
            subscriber = this.subscriber();
            if (subscriber != null && this.stalled) {
                this.stalled = false;
            }
        }
        if (subscriber != null) {
            this.proceed(subscriber);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceed(Subscriber<? super T> subscriber) {
        while (true) {
            Object t;
            boolean terminal;
            Object item;
            QueuedSinglePublisher queuedSinglePublisher = this;
            synchronized (queuedSinglePublisher) {
                item = this.items.peek();
                if (item == null) {
                    this.stalled = true;
                    return;
                }
                if (this.demand > 0L) {
                    --this.demand;
                } else {
                    this.stalled = true;
                    return;
                }
                terminal = this.isTerminal(item);
                item = this.items.poll();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("processing {} item {} by {}", new Object[]{terminal ? "last" : "next", item, this});
            }
            if (terminal) {
                t = (Terminal)item;
                t.notify(subscriber);
                continue;
            }
            t = item;
            subscriber.onNext(t);
        }
    }

    private boolean isTerminal(Object item) {
        return item instanceof Terminal;
    }

    private class Failure<F>
    implements Terminal<F> {
        private final Throwable failure;

        private Failure(Throwable failure) {
            this.failure = failure;
        }

        @Override
        public void notify(Subscriber<? super F> subscriber) {
            subscriber.onError(this.failure);
        }
    }

    @FunctionalInterface
    private static interface Terminal<T> {
        public void notify(Subscriber<? super T> var1);
    }
}

