/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSinglePublisher<T>
implements Publisher<T>,
Subscription {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Subscriber<? super T> subscriber;
    private boolean cancelled;

    protected static long cappedAdd(long x, long y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "invalid 'null' subscriber");
        IllegalStateException failure = null;
        AbstractSinglePublisher abstractSinglePublisher = this;
        synchronized (abstractSinglePublisher) {
            if (this.subscriber != null) {
                failure = new IllegalStateException("multiple subscribers not supported");
            } else if (this.isCancelled()) {
                failure = new CancellationException();
            } else {
                this.subscriber = subscriber;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} subscription from {}", (Object)this, subscriber);
        }
        subscriber.onSubscribe((Subscription)this);
        if (failure != null) {
            this.onFailure(subscriber, failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscriber<? super T> subscriber() {
        AbstractSinglePublisher abstractSinglePublisher = this;
        synchronized (abstractSinglePublisher) {
            return this.subscriber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        Subscriber<T> subscriber;
        IllegalArgumentException failure = null;
        AbstractSinglePublisher abstractSinglePublisher = this;
        synchronized (abstractSinglePublisher) {
            if (this.isCancelled()) {
                return;
            }
            subscriber = this.subscriber();
            if (n <= 0L) {
                failure = new IllegalArgumentException("reactive stream violation rule 3.9");
            }
        }
        if (failure != null) {
            this.onFailure(subscriber, failure);
        } else {
            this.onRequest(subscriber, n);
        }
    }

    protected abstract void onRequest(Subscriber<? super T> var1, long var2);

    protected void onFailure(Subscriber<? super T> subscriber, Throwable failure) {
        subscriber.onError(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Subscriber<? super T> subscriber;
        AbstractSinglePublisher abstractSinglePublisher = this;
        synchronized (abstractSinglePublisher) {
            this.cancelled = true;
            subscriber = this.subscriber;
            this.subscriber = null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} cancelled subscription from {}", (Object)this, subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCancelled() {
        AbstractSinglePublisher abstractSinglePublisher = this;
        synchronized (abstractSinglePublisher) {
            return this.cancelled;
        }
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

