/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.Map;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UriTemplatePathSpecTest {
    private void assertDetectedVars(UriTemplatePathSpec spec, String ... expectedVars) {
        String prefix = String.format("Spec(\"%s\")", spec.getDeclaration());
        Assertions.assertEquals((int)expectedVars.length, (int)spec.getVariableCount(), (String)(prefix + ".variableCount"));
        Assertions.assertEquals((int)expectedVars.length, (int)spec.getVariables().length, (String)(prefix + ".variable.length"));
        for (int i = 0; i < expectedVars.length; ++i) {
            MatcherAssert.assertThat((String)String.format("%s.variable[%d]", prefix, i), (Object)spec.getVariables()[i], (Matcher)Matchers.is((Object)expectedVars[i]));
        }
    }

    private void assertMatches(PathSpec spec, String path) {
        String msg = String.format("Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        MatcherAssert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)true));
    }

    private void assertNotMatches(PathSpec spec, String path) {
        String msg = String.format("!Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        MatcherAssert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testDefaultPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/");
        Assertions.assertEquals((Object)"/", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.EXACT, (Object)spec.getGroup(), (String)"Spec.group");
        Assertions.assertEquals((int)0, (int)spec.getVariableCount(), (String)"Spec.variableCount");
        Assertions.assertEquals((int)0, (int)spec.getVariables().length, (String)"Spec.variable.length");
    }

    @Test
    public void testExactOnePathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a");
        Assertions.assertEquals((Object)"/a", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/a$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.EXACT, (Object)spec.getGroup(), (String)"Spec.group");
        this.assertMatches((PathSpec)spec, "/a");
        this.assertMatches((PathSpec)spec, "/a?type=other");
        this.assertNotMatches((PathSpec)spec, "/a/b");
        this.assertNotMatches((PathSpec)spec, "/a/");
        Assertions.assertEquals((int)0, (int)spec.getVariableCount(), (String)"Spec.variableCount");
        Assertions.assertEquals((int)0, (int)spec.getVariables().length, (String)"Spec.variable.length");
    }

    @Test
    public void testExactPathSpecTestWebapp() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/deep.thought/");
        Assertions.assertEquals((Object)"/deep.thought/", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/deep\\.thought/$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.EXACT, (Object)spec.getGroup(), (String)"Spec.group");
        this.assertMatches((PathSpec)spec, "/deep.thought/");
        this.assertNotMatches((PathSpec)spec, "/deep.thought");
        Assertions.assertEquals((int)0, (int)spec.getVariableCount(), (String)"Spec.variableCount");
        Assertions.assertEquals((int)0, (int)spec.getVariables().length, (String)"Spec.variable.length");
    }

    @Test
    public void testExactTwoPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a/b");
        Assertions.assertEquals((Object)"/a/b", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/a/b$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.EXACT, (Object)spec.getGroup(), (String)"Spec.group");
        Assertions.assertEquals((int)0, (int)spec.getVariableCount(), (String)"Spec.variableCount");
        Assertions.assertEquals((int)0, (int)spec.getVariables().length, (String)"Spec.variable.length");
        this.assertMatches((PathSpec)spec, "/a/b");
        this.assertNotMatches((PathSpec)spec, "/a/b/");
        this.assertNotMatches((PathSpec)spec, "/a/");
        this.assertNotMatches((PathSpec)spec, "/a/bb");
    }

    @Test
    public void testMiddleVarPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a/{var}/c");
        Assertions.assertEquals((Object)"/a/{var}/c", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/a/([^/]+)/c$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)3, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        this.assertDetectedVars(spec, "var");
        this.assertMatches((PathSpec)spec, "/a/b/c");
        this.assertMatches((PathSpec)spec, "/a/zz/c");
        this.assertMatches((PathSpec)spec, "/a/hello+world/c");
        this.assertNotMatches((PathSpec)spec, "/a/bc");
        this.assertNotMatches((PathSpec)spec, "/a/b/");
        this.assertNotMatches((PathSpec)spec, "/a/b");
        Map mapped = spec.getPathParams("/a/b/c");
        MatcherAssert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)1));
        Assertions.assertEquals((Object)"b", mapped.get("var"), (String)"Spec.pathParams[var]");
    }

    @Test
    public void testOneVarPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a/{foo}");
        Assertions.assertEquals((Object)"/a/{foo}", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/a/([^/]+)$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.PREFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        this.assertDetectedVars(spec, "foo");
        this.assertMatches((PathSpec)spec, "/a/b");
        this.assertNotMatches((PathSpec)spec, "/a/");
        this.assertNotMatches((PathSpec)spec, "/a");
        Map mapped = spec.getPathParams("/a/b");
        MatcherAssert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)1));
        Assertions.assertEquals((Object)"b", mapped.get("foo"), (String)"Spec.pathParams[foo]");
    }

    @Test
    public void testOneVarSuffixPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/{var}/b/c");
        Assertions.assertEquals((Object)"/{var}/b/c", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/([^/]+)/b/c$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)3, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.SUFFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        this.assertDetectedVars(spec, "var");
        this.assertMatches((PathSpec)spec, "/a/b/c");
        this.assertMatches((PathSpec)spec, "/az/b/c");
        this.assertMatches((PathSpec)spec, "/hello+world/b/c");
        this.assertNotMatches((PathSpec)spec, "/a/bc");
        this.assertNotMatches((PathSpec)spec, "/a/b/");
        this.assertNotMatches((PathSpec)spec, "/a/b");
        Map mapped = spec.getPathParams("/a/b/c");
        MatcherAssert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)1));
        Assertions.assertEquals((Object)"a", mapped.get("var"), (String)"Spec.pathParams[var]");
    }

    @Test
    public void testTwoVarComplexInnerPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a/{var1}/c/{var2}/e");
        Assertions.assertEquals((Object)"/a/{var1}/c/{var2}/e", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/a/([^/]+)/c/([^/]+)/e$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)5, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        this.assertDetectedVars(spec, "var1", "var2");
        this.assertMatches((PathSpec)spec, "/a/b/c/d/e");
        this.assertNotMatches((PathSpec)spec, "/a/bc/d/e");
        this.assertNotMatches((PathSpec)spec, "/a/b/d/e");
        this.assertNotMatches((PathSpec)spec, "/a/b//d/e");
        Map mapped = spec.getPathParams("/a/b/c/d/e");
        MatcherAssert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)2));
        Assertions.assertEquals((Object)"b", mapped.get("var1"), (String)"Spec.pathParams[var1]");
        Assertions.assertEquals((Object)"d", mapped.get("var2"), (String)"Spec.pathParams[var2]");
    }

    @Test
    public void testTwoVarComplexOuterPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/{var1}/b/{var2}/{var3}");
        Assertions.assertEquals((Object)"/{var1}/b/{var2}/{var3}", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/([^/]+)/b/([^/]+)/([^/]+)$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)4, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        this.assertDetectedVars(spec, "var1", "var2", "var3");
        this.assertMatches((PathSpec)spec, "/a/b/c/d");
        this.assertNotMatches((PathSpec)spec, "/a/bc/d/e");
        this.assertNotMatches((PathSpec)spec, "/a/c/d/e");
        this.assertNotMatches((PathSpec)spec, "/a//d/e");
        Map mapped = spec.getPathParams("/a/b/c/d");
        MatcherAssert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)3));
        Assertions.assertEquals((Object)"a", mapped.get("var1"), (String)"Spec.pathParams[var1]");
        Assertions.assertEquals((Object)"c", mapped.get("var2"), (String)"Spec.pathParams[var2]");
        Assertions.assertEquals((Object)"d", mapped.get("var3"), (String)"Spec.pathParams[var3]");
    }

    @Test
    public void testTwoVarPrefixPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a/{var1}/{var2}");
        Assertions.assertEquals((Object)"/a/{var1}/{var2}", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/a/([^/]+)/([^/]+)$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)3, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.PREFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        this.assertDetectedVars(spec, "var1", "var2");
        this.assertMatches((PathSpec)spec, "/a/b/c");
        this.assertNotMatches((PathSpec)spec, "/a/bc");
        this.assertNotMatches((PathSpec)spec, "/a/b/");
        this.assertNotMatches((PathSpec)spec, "/a/b");
        Map mapped = spec.getPathParams("/a/b/c");
        MatcherAssert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)2));
        Assertions.assertEquals((Object)"b", mapped.get("var1"), (String)"Spec.pathParams[var1]");
        Assertions.assertEquals((Object)"c", mapped.get("var2"), (String)"Spec.pathParams[var2]");
    }

    @Test
    public void testVarOnlyPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/{var1}");
        Assertions.assertEquals((Object)"/{var1}", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/([^/]+)$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.PREFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        this.assertDetectedVars(spec, "var1");
        this.assertMatches((PathSpec)spec, "/a");
        this.assertNotMatches((PathSpec)spec, "/");
        this.assertNotMatches((PathSpec)spec, "/a/b");
        this.assertNotMatches((PathSpec)spec, "/a/b/c");
        Map mapped = spec.getPathParams("/a");
        MatcherAssert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)1));
        Assertions.assertEquals((Object)"a", mapped.get("var1"), (String)"Spec.pathParams[var1]");
    }

    @Test
    public void testEquals() {
        MatcherAssert.assertThat((Object)new UriTemplatePathSpec("/{var1}"), (Matcher)Matchers.equalTo((Object)new UriTemplatePathSpec("/{var1}")));
        MatcherAssert.assertThat((Object)new UriTemplatePathSpec("/{var1}"), (Matcher)Matchers.equalTo((Object)new UriTemplatePathSpec("/{var2}")));
        MatcherAssert.assertThat((Object)new UriTemplatePathSpec("/{var1}/{var2}"), (Matcher)Matchers.equalTo((Object)new UriTemplatePathSpec("/{var2}/{var1}")));
        MatcherAssert.assertThat((Object)new UriTemplatePathSpec("/{var1}"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new UriTemplatePathSpec("/{var1}/{var2}"))));
        MatcherAssert.assertThat((Object)new UriTemplatePathSpec("/a/b/c"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new UriTemplatePathSpec("/a/{var}/c"))));
        MatcherAssert.assertThat((Object)new UriTemplatePathSpec("/foo"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new ServletPathSpec("/foo"))));
    }
}

