/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpEventListener;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.SelectConnector;
import org.eclipse.jetty.client.security.Authentication;
import org.eclipse.jetty.client.security.SecurityListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;

public class HttpDestination
implements Dumpable {
    private final List<HttpExchange> _queue = new LinkedList<HttpExchange>();
    private final List<HttpConnection> _connections = new LinkedList<HttpConnection>();
    private final BlockingQueue<Object> _newQueue = new ArrayBlockingQueue<Object>(10, true);
    private final List<HttpConnection> _idle = new ArrayList<HttpConnection>();
    private final HttpClient _client;
    private final Address _address;
    private final boolean _ssl;
    private final ByteArrayBuffer _hostHeader;
    private volatile int _maxConnections;
    private volatile int _maxQueueSize;
    private int _pendingConnections = 0;
    private int _newConnection = 0;
    private volatile Address _proxy;
    private Authentication _proxyAuthentication;
    private PathMap _authorizations;
    private List<HttpCookie> _cookies;

    HttpDestination(HttpClient client, Address address, boolean ssl) {
        this._client = client;
        this._address = address;
        this._ssl = ssl;
        this._maxConnections = this._client.getMaxConnectionsPerAddress();
        this._maxQueueSize = this._client.getMaxQueueSizePerAddress();
        String addressString = address.getHost();
        if (address.getPort() != (this._ssl ? 443 : 80)) {
            addressString = addressString + ":" + address.getPort();
        }
        this._hostHeader = new ByteArrayBuffer(addressString);
    }

    public HttpClient getHttpClient() {
        return this._client;
    }

    public Address getAddress() {
        return this._address;
    }

    public boolean isSecure() {
        return this._ssl;
    }

    public Buffer getHostHeader() {
        return this._hostHeader;
    }

    public int getMaxConnections() {
        return this._maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this._maxConnections = maxConnections;
    }

    public int getMaxQueueSize() {
        return this._maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this._maxQueueSize = maxQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnections() {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            return this._connections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleConnections() {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            return this._idle.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthorization(String pathSpec, Authentication authorization) {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            if (this._authorizations == null) {
                this._authorizations = new PathMap();
            }
            this._authorizations.put((Object)pathSpec, (Object)authorization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(HttpCookie cookie) {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            if (this._cookies == null) {
                this._cookies = new ArrayList<HttpCookie>();
            }
            this._cookies.add(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpConnection getConnection(long timeout) throws IOException {
        HttpConnection connection = null;
        while (connection == null && (connection = this.getIdleConnection()) == null && timeout > 0L) {
            boolean startConnection = false;
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                int totalConnections = this._connections.size() + this._pendingConnections;
                if (totalConnections < this._maxConnections) {
                    ++this._newConnection;
                    startConnection = true;
                }
            }
            if (startConnection) {
                this.startNewConnection();
                try {
                    Object o = this._newQueue.take();
                    if (o instanceof HttpConnection) {
                        connection = (HttpConnection)((Object)o);
                        continue;
                    }
                    throw (IOException)o;
                }
                catch (InterruptedException e) {
                    Log.ignore((Throwable)e);
                    continue;
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(200L);
                timeout -= 200L;
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
            }
        }
        return connection;
    }

    public HttpConnection reserveConnection(long timeout) throws IOException {
        HttpConnection connection = this.getConnection(timeout);
        if (connection != null) {
            connection.setReserved(true);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpConnection getIdleConnection() throws IOException {
        HttpConnection connection = null;
        do {
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                if (connection != null) {
                    this._connections.remove((Object)connection);
                    connection.close();
                    connection = null;
                }
                if (this._idle.size() > 0) {
                    connection = this._idle.remove(this._idle.size() - 1);
                }
            }
            if (connection != null) continue;
            return null;
        } while (!connection.cancelIdleTimeout());
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startNewConnection() {
        try {
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                ++this._pendingConnections;
            }
            HttpClient.Connector connector = this._client._connector;
            if (connector != null) {
                connector.startConnection(this);
            }
        }
        catch (Exception e) {
            Log.debug((Throwable)e);
            this.onConnectionFailed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionFailed(Throwable throwable) {
        Throwable connect_failure = null;
        boolean startConnection = false;
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            --this._pendingConnections;
            if (this._newConnection > 0) {
                connect_failure = throwable;
                --this._newConnection;
            } else if (this._queue.size() > 0) {
                HttpExchange ex = this._queue.remove(0);
                ex.setStatus(9);
                ex.getEventListener().onConnectionFailed(throwable);
                if (!this._queue.isEmpty() && this._client.isStarted()) {
                    startConnection = true;
                }
            }
        }
        if (startConnection) {
            this.startNewConnection();
        }
        if (connect_failure != null) {
            try {
                this._newQueue.put(connect_failure);
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(Throwable throwable) {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            --this._pendingConnections;
            if (this._queue.size() > 0) {
                HttpExchange ex = this._queue.remove(0);
                ex.setStatus(9);
                ex.getEventListener().onException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewConnection(HttpConnection connection) throws IOException {
        HttpConnection q_connection = null;
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            --this._pendingConnections;
            this._connections.add(connection);
            if (this._newConnection > 0) {
                q_connection = connection;
                --this._newConnection;
            } else if (this._queue.size() == 0) {
                connection.setIdleTimeout();
                this._idle.add(connection);
            } else {
                EndPoint endPoint = connection.getEndPoint();
                if (this.isProxied() && endPoint instanceof SelectConnector.ProxySelectChannelEndPoint) {
                    SelectConnector.ProxySelectChannelEndPoint proxyEndPoint = (SelectConnector.ProxySelectChannelEndPoint)endPoint;
                    HttpExchange exchange = this._queue.get(0);
                    ConnectExchange connect = new ConnectExchange(this.getAddress(), proxyEndPoint, exchange);
                    connect.setAddress(this.getProxy());
                    this.send(connection, connect);
                } else {
                    HttpExchange exchange = this._queue.remove(0);
                    this.send(connection, exchange);
                }
            }
        }
        if (q_connection != null) {
            try {
                this._newQueue.put((Object)q_connection);
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(HttpConnection connection, boolean close) throws IOException {
        if (connection.isReserved()) {
            connection.setReserved(false);
        }
        if (close) {
            try {
                connection.close();
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
            }
        }
        if (!this._client.isStarted()) {
            return;
        }
        if (!close && connection.getEndPoint().isOpen()) {
            HttpDestination e = this;
            synchronized (e) {
                if (this._queue.size() == 0) {
                    connection.setIdleTimeout();
                    this._idle.add(connection);
                } else {
                    HttpExchange ex = this._queue.remove(0);
                    this.send(connection, ex);
                }
                this.notifyAll();
            }
        }
        boolean startConnection = false;
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            this._connections.remove((Object)connection);
            if (!this._queue.isEmpty()) {
                startConnection = true;
            }
        }
        if (startConnection) {
            this.startNewConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnIdleConnection(HttpConnection connection) {
        try {
            connection.close();
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
        boolean startConnection = false;
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            this._idle.remove((Object)connection);
            this._connections.remove((Object)connection);
            if (!this._queue.isEmpty() && this._client.isStarted()) {
                startConnection = true;
            }
        }
        if (startConnection) {
            this.startNewConnection();
        }
    }

    public void send(HttpExchange ex) throws IOException {
        LinkedList<String> listeners = this._client.getRegisteredListeners();
        if (listeners != null) {
            for (int i = listeners.size(); i > 0; --i) {
                String listenerClass = listeners.get(i - 1);
                try {
                    Class<?> listener = Class.forName(listenerClass);
                    Constructor<?> constructor = listener.getDeclaredConstructor(HttpDestination.class, HttpExchange.class);
                    HttpEventListener elistener = (HttpEventListener)constructor.newInstance(this, ex);
                    ex.setEventListener(elistener);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("Unable to instantiate registered listener for destination: " + listenerClass);
                }
            }
        }
        if (this._client.hasRealms()) {
            ex.setEventListener(new SecurityListener(this, ex));
        }
        this.doSend(ex);
    }

    public void resend(HttpExchange ex) throws IOException {
        ex.getEventListener().onRetry();
        ex.reset();
        this.doSend(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(HttpExchange ex) throws IOException {
        Authentication auth;
        if (this._cookies != null) {
            StringBuilder buf = null;
            for (HttpCookie cookie : this._cookies) {
                if (buf == null) {
                    buf = new StringBuilder();
                } else {
                    buf.append("; ");
                }
                buf.append(cookie.getName());
                buf.append("=");
                buf.append(cookie.getValue());
            }
            if (buf != null) {
                ex.addRequestHeader("Cookie", buf.toString());
            }
        }
        if (this._authorizations != null && (auth = (Authentication)this._authorizations.match(ex.getURI())) != null) {
            auth.setCredentials(ex);
        }
        ex.scheduleTimeout(this);
        HttpConnection connection = this.getIdleConnection();
        if (connection != null) {
            this.send(connection, ex);
        } else {
            boolean startConnection = false;
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                if (this._queue.size() == this._maxQueueSize) {
                    throw new RejectedExecutionException("Queue full for address " + this._address);
                }
                this._queue.add(ex);
                if (this._connections.size() + this._pendingConnections < this._maxConnections) {
                    startConnection = true;
                }
            }
            if (startConnection) {
                this.startNewConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exchangeExpired(HttpExchange exchange) {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            this._queue.remove(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(HttpConnection connection, HttpExchange exchange) throws IOException {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            if (!connection.send(exchange)) {
                if (exchange.getStatus() <= 1) {
                    this._queue.add(0, exchange);
                }
                this.returnIdleConnection(connection);
            }
        }
    }

    public synchronized String toString() {
        return "HttpDestination@" + this.hashCode() + "//" + this._address.getHost() + ":" + this._address.getPort() + "(" + this._connections.size() + "," + this._idle.size() + "," + this._queue.size() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toDetailString() {
        StringBuilder b = new StringBuilder();
        b.append(this.toString());
        b.append('\n');
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            for (HttpConnection connection : this._connections) {
                b.append(connection.toDetailString());
                if (this._idle.contains((Object)connection)) {
                    b.append(" IDLE");
                }
                b.append('\n');
            }
        }
        b.append("--");
        b.append('\n');
        return b.toString();
    }

    public void setProxy(Address proxy) {
        this._proxy = proxy;
    }

    public Address getProxy() {
        return this._proxy;
    }

    public Authentication getProxyAuthentication() {
        return this._proxyAuthentication;
    }

    public void setProxyAuthentication(Authentication authentication) {
        this._proxyAuthentication = authentication;
    }

    public boolean isProxied() {
        return this._proxy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            for (HttpConnection connection : this._connections) {
                connection.close();
            }
        }
    }

    public String dump() {
        return AggregateLifeCycle.dump((Dumpable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            out.append(String.valueOf(this) + "idle=" + this._idle.size() + " pending=" + this._pendingConnections).append("\n");
            AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this._connections});
        }
    }

    private class ConnectExchange
    extends ContentExchange {
        private final SelectConnector.ProxySelectChannelEndPoint proxyEndPoint;
        private final HttpExchange exchange;

        public ConnectExchange(Address serverAddress, SelectConnector.ProxySelectChannelEndPoint proxyEndPoint, HttpExchange exchange) {
            this.proxyEndPoint = proxyEndPoint;
            this.exchange = exchange;
            this.setMethod("CONNECT");
            String serverHostAndPort = serverAddress.toString();
            this.setURI(serverHostAndPort);
            this.addRequestHeader("Host", serverHostAndPort);
            this.addRequestHeader("Proxy-Connection", "keep-alive");
            this.addRequestHeader("User-Agent", "Jetty-Client");
        }

        @Override
        protected void onResponseComplete() throws IOException {
            if (this.getResponseStatus() == 200) {
                this.proxyEndPoint.upgrade();
            } else {
                this.onConnectionFailed(new ConnectException(this.exchange.getAddress().toString()));
            }
        }

        @Override
        protected void onConnectionFailed(Throwable x) {
            HttpDestination.this.onConnectionFailed(x);
        }
    }
}

