/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.jetty.ee10.servlet.AsyncContextEvent;
import org.eclipse.jetty.ee10.servlet.AsyncContextState;
import org.eclipse.jetty.ee10.servlet.PushBuilderImpl;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletChannelState;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletMultiPartFormData;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.CookieCache;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.HttpCookieUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletApiRequest
implements HttpServletRequest {
    private static final Logger LOG = LoggerFactory.getLogger(ServletApiRequest.class);
    private final ServletContextRequest _servletContextRequest;
    private final ServletChannel _servletChannel;
    private AsyncContextState _async;
    private String _characterEncoding;
    private int _inputState = 0;
    private BufferedReader _reader;
    private String _readerEncoding;
    private String _contentType;
    private boolean _contentParamsExtracted;
    private Fields _contentParameters;
    private Fields _parameters;
    private Fields _queryParameters;
    private ServletMultiPartFormData.Parts _parts;
    private boolean _asyncSupported = true;

    protected ServletApiRequest(ServletContextRequest servletContextRequest) {
        this._servletContextRequest = servletContextRequest;
        this._servletChannel = this._servletContextRequest.getServletChannel();
    }

    public AuthenticationState getAuthentication() {
        return AuthenticationState.getAuthenticationState((Request)this.getRequest());
    }

    private AuthenticationState getUndeferredAuthentication() {
        AuthenticationState.Deferred deferred;
        AuthenticationState.Succeeded undeferred;
        AuthenticationState authenticationState = this.getAuthentication();
        if (authenticationState instanceof AuthenticationState.Deferred && (undeferred = (deferred = (AuthenticationState.Deferred)authenticationState).authenticate(this.getRequest())) != null && undeferred != authenticationState) {
            authenticationState = undeferred;
            AuthenticationState.setAuthenticationState((Request)this.getRequest(), (AuthenticationState)authenticationState);
        }
        return authenticationState;
    }

    public String getMethod() {
        return this.getRequest().getMethod();
    }

    public ServletContextHandler.ServletRequestInfo getServletRequestInfo() {
        return this._servletContextRequest;
    }

    public Request getRequest() {
        ServletChannel servletChannel = this._servletChannel;
        return servletChannel == null ? this._servletContextRequest : servletChannel.getRequest();
    }

    public HttpFields getFields() {
        return this.getRequest().getHeaders();
    }

    public String getRequestId() {
        return this.getRequest().getConnectionMetaData().getId() + "#" + this.getRequest().getId();
    }

    public String getProtocolRequestId() {
        return this.getRequest().getId();
    }

    public ServletConnection getServletConnection() {
        final ConnectionMetaData connectionMetaData = this.getRequest().getConnectionMetaData();
        return new ServletConnection(){

            public String getConnectionId() {
                return connectionMetaData.getId();
            }

            public String getProtocol() {
                return connectionMetaData.getProtocol();
            }

            public String getProtocolConnectionId() {
                if (HttpVersion.HTTP_3.is(connectionMetaData.getProtocol())) {
                    return connectionMetaData.getId();
                }
                return "";
            }

            public boolean isSecure() {
                return connectionMetaData.isSecure();
            }
        };
    }

    public String getAuthType() {
        AuthenticationState authenticationState = this.getUndeferredAuthentication();
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            AuthenticationState.Succeeded succeededAuthentication = (AuthenticationState.Succeeded)authenticationState;
            return succeededAuthentication.getAuthenticationType();
        }
        return null;
    }

    public Cookie[] getCookies() {
        List httpCookies = Request.getCookies((Request)this.getRequest());
        if (httpCookies.isEmpty()) {
            return null;
        }
        if (httpCookies instanceof ServletCookieList) {
            ServletCookieList servletCookieList = (ServletCookieList)httpCookies;
            return servletCookieList.getServletCookies();
        }
        ServletCookieList servletCookieList = new ServletCookieList(httpCookies, this.getRequest().getConnectionMetaData().getHttpConfiguration().getRequestCookieCompliance());
        this.getRequest().setAttribute(Request.COOKIE_ATTRIBUTE, (Object)servletCookieList);
        Object object = this.getRequest().getComponents().getCache().getAttribute(Request.CACHE_ATTRIBUTE);
        if (object instanceof CookieCache) {
            CookieCache cookieCache = (CookieCache)object;
            cookieCache.replaceCookieList((List)servletCookieList);
        }
        return servletCookieList.getServletCookies();
    }

    public long getDateHeader(String name) {
        HttpFields fields = this.getFields();
        if (fields == null) {
            return -1L;
        }
        HttpField field = fields.getField(name);
        if (field == null) {
            return -1L;
        }
        long date = fields.getDateField(name);
        if (date == -1L) {
            throw new IllegalArgumentException("Cannot parse date");
        }
        return date;
    }

    public String getHeader(String name) {
        return this.getFields().get(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.getFields().getValues(name);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.getFields().getFieldNamesCollection());
    }

    public int getIntHeader(String name) {
        HttpFields fields = this.getFields();
        return fields == null ? -1 : (int)fields.getLongField(name);
    }

    public String getPathInfo() {
        return this.getServletRequestInfo().getMatchedResource().getMatchedPath().getPathInfo();
    }

    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null || this.getServletRequestInfo().getServletContext() == null) {
            return null;
        }
        return this.getServletRequestInfo().getServletContext().getServletContext().getRealPath(pathInfo);
    }

    public String getContextPath() {
        return this.getServletRequestInfo().getServletContext().getServletContextHandler().getRequestContextPath();
    }

    public String getQueryString() {
        return this.getRequest().getHttpURI().getQuery();
    }

    public String getRemoteUser() {
        Principal p = this.getUserPrincipal();
        if (p == null) {
            return null;
        }
        return p.getName();
    }

    public boolean isUserInRole(String role) {
        String linkedRole = ((ServletHandler.MappedServlet)this.getServletRequestInfo().getMatchedResource().getResource()).getServletHolder().getUserRoleLink(role);
        AuthenticationState authenticationState = this.getUndeferredAuthentication();
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            AuthenticationState.Succeeded succeededAuthentication = (AuthenticationState.Succeeded)authenticationState;
            return succeededAuthentication.isUserInRole(linkedRole);
        }
        return false;
    }

    public Principal getUserPrincipal() {
        AuthenticationState authenticationState = this.getUndeferredAuthentication();
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            AuthenticationState.Succeeded succeededAuthentication = (AuthenticationState.Succeeded)authenticationState;
            UserIdentity user = succeededAuthentication.getUserIdentity();
            return user.getUserPrincipal();
        }
        return null;
    }

    public String getRequestedSessionId() {
        AbstractSessionManager.RequestedSession requestedSession = this.getServletRequestInfo().getRequestedSession();
        return requestedSession == null ? null : requestedSession.sessionId();
    }

    public String getRequestURI() {
        HttpURI uri = this.getRequest().getHttpURI();
        return uri == null ? null : uri.getPath();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(HttpURI.build((HttpURI)this.getRequest().getHttpURI()).query(null).asString());
    }

    public String getServletPath() {
        return this.getServletRequestInfo().getMatchedResource().getMatchedPath().getPathMatch();
    }

    public HttpSession getSession(boolean create) {
        Session session = this.getRequest().getSession(create);
        if (session == null) {
            return null;
        }
        if (session.isNew() && this.getAuthentication() instanceof AuthenticationState.Succeeded) {
            session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
        }
        return (HttpSession)session.getApi();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        Session session = this.getRequest().getSession(false);
        if (session == null) {
            throw new IllegalStateException("No session");
        }
        session.renewId(this.getRequest(), this._servletChannel.getResponse());
        if (this.getRemoteUser() != null) {
            session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
        }
        return session.getId();
    }

    public boolean isRequestedSessionIdValid() {
        AbstractSessionManager.RequestedSession requestedSession = this.getServletRequestInfo().getRequestedSession();
        return requestedSession != null && requestedSession.sessionId() != null && requestedSession.session() != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        AbstractSessionManager.RequestedSession requestedSession = this.getServletRequestInfo().getRequestedSession();
        return requestedSession != null && requestedSession.sessionId() != null && requestedSession.sessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        AbstractSessionManager.RequestedSession requestedSession = this.getServletRequestInfo().getRequestedSession();
        return requestedSession != null && requestedSession.sessionId() != null && !requestedSession.sessionIdFromCookie();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this.getUserPrincipal() != null && this.getRemoteUser() != null && this.getAuthType() != null) {
            return true;
        }
        AuthenticationState authenticationState = this.getUndeferredAuthentication();
        if (authenticationState instanceof AuthenticationState.Deferred) {
            response.sendError(401);
        }
        if (!(authenticationState instanceof AuthenticationState.ResponseSent)) {
            return false;
        }
        throw new ServletException("Authentication failed");
    }

    public void login(String username, String password) throws ServletException {
        try {
            ServletContextHandler.ServletRequestInfo servletRequestInfo = this.getServletRequestInfo();
            AuthenticationState.Succeeded succeededAuthentication = AuthenticationState.login((String)username, (String)password, (Request)this.getRequest(), (Response)servletRequestInfo.getServletChannel().getServletContextResponse());
            if (succeededAuthentication == null) {
                throw new QuietException.Exception("Authentication failed for username '" + username + "'");
            }
        }
        catch (Throwable t) {
            throw new ServletException(t.getMessage(), t);
        }
    }

    public void logout() throws ServletException {
        ServletContextHandler.ServletRequestInfo servletRequestInfo = this.getServletRequestInfo();
        if (!AuthenticationState.logout((Request)this.getRequest(), (Response)servletRequestInfo.getServletChannel().getServletContextResponse())) {
            throw new ServletException("logout failed");
        }
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this._parts == null) {
            try {
                CompletableFuture<ServletMultiPartFormData.Parts> futureServletMultiPartFormData = ServletMultiPartFormData.from((ServletRequest)this);
                this._parts = futureServletMultiPartFormData.get();
                Collection<Part> parts = this._parts.getParts();
                String formCharset = null;
                Part charsetPart = this._parts.getPart("_charset_");
                if (charsetPart != null) {
                    try (InputStream is = charsetPart.getInputStream();){
                        formCharset = IO.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    }
                }
                Charset defaultCharset = formCharset != null ? Charset.forName(formCharset) : (this.getCharacterEncoding() != null ? Charset.forName(this.getCharacterEncoding()) : StandardCharsets.UTF_8);
                ServletContextHandler servletContextHandler = this.getServletRequestInfo().getServletContext().getServletContextHandler();
                long maxFormContentSize = servletContextHandler.getMaxFormContentSize();
                int maxFormKeys = servletContextHandler.getMaxFormKeys();
                long formContentSize = 0L;
                int count = 0;
                for (Part p : parts) {
                    if (maxFormKeys > 0 && ++count > maxFormKeys) {
                        throw new IllegalStateException("Too many form keys > " + maxFormKeys);
                    }
                    if (p.getSubmittedFileName() != null) continue;
                    formContentSize = Math.addExact(formContentSize, p.getSize());
                    if (maxFormContentSize >= 0L && formContentSize > maxFormContentSize) {
                        throw new IllegalStateException("Form is larger than max length " + maxFormContentSize);
                    }
                    String charset = null;
                    if (p.getContentType() != null) {
                        charset = MimeTypes.getCharsetFromContentType((String)p.getContentType());
                    }
                    InputStream is = p.getInputStream();
                    try {
                        String content = IO.toString((InputStream)is, (Charset)(charset == null ? defaultCharset : Charset.forName(charset)));
                        if (this._contentParameters == null) {
                            this._contentParameters = new Fields();
                        }
                        this._contentParameters.add(p.getName(), content);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (Throwable t) {
                Throwable cause;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getParts", t);
                }
                if (t instanceof ExecutionException) {
                    ExecutionException ee = (ExecutionException)t;
                    cause = ee.getCause();
                } else if (t instanceof ServletException) {
                    ServletException se = (ServletException)t;
                    cause = se.getCause();
                } else {
                    cause = t;
                }
                if (cause instanceof IOException) {
                    IOException ioException = (IOException)cause;
                    throw ioException;
                }
                throw new ServletException((Throwable)new BadMessageException("bad multipart", cause));
            }
        }
        return this._parts.getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        this.getParts();
        return this._parts.getPart(name);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new ServletException("Not implemented");
    }

    public PushBuilder newPushBuilder() {
        String sessionId;
        HttpSession httpSession;
        if (!this.getRequest().getConnectionMetaData().isPushSupported()) {
            return null;
        }
        HttpFields.Mutable pushHeaders = HttpFields.build((HttpFields)this.getRequest().getHeaders(), EnumSet.of(HttpHeader.IF_MATCH, new HttpHeader[]{HttpHeader.IF_RANGE, HttpHeader.IF_UNMODIFIED_SINCE, HttpHeader.RANGE, HttpHeader.EXPECT, HttpHeader.IF_NONE_MATCH, HttpHeader.IF_MODIFIED_SINCE}));
        Object referrer = this.getRequestURL().toString();
        String query = this.getQueryString();
        if (query != null) {
            referrer = (String)referrer + "?" + query;
        }
        pushHeaders.put(HttpHeader.REFERER, (String)referrer);
        HttpFields.Mutable responseHeaders = this._servletChannel.getResponse().getHeaders();
        ArrayList setCookies = new ArrayList(responseHeaders.getValuesList(HttpHeader.SET_COOKIE));
        setCookies.addAll(responseHeaders.getValuesList(HttpHeader.SET_COOKIE2));
        String cookies = pushHeaders.get(HttpHeader.COOKIE);
        if (!setCookies.isEmpty()) {
            StringBuilder pushCookies = new StringBuilder();
            if (cookies != null) {
                pushCookies.append(cookies);
            }
            for (String setCookie : setCookies) {
                Map cookieFields = HttpCookieUtils.extractBasics((String)setCookie);
                String cookieName = (String)cookieFields.get("name");
                String cookieValue = (String)cookieFields.get("value");
                String cookieMaxAge = (String)cookieFields.get("max-age");
                long maxAge = cookieMaxAge != null ? Long.parseLong(cookieMaxAge) : -1L;
                if (maxAge <= 0L) continue;
                if (pushCookies.length() > 0) {
                    pushCookies.append("; ");
                }
                pushCookies.append(cookieName).append("=").append(cookieValue);
            }
            pushHeaders.put(HttpHeader.COOKIE, pushCookies.toString());
        }
        if ((httpSession = this.getSession(false)) != null) {
            try {
                httpSession.getLastAccessedTime();
                sessionId = httpSession.getId();
            }
            catch (Throwable x) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("invalid HTTP session", x);
                }
                sessionId = this.getRequestedSessionId();
            }
        } else {
            sessionId = this.getRequestedSessionId();
        }
        return new PushBuilderImpl(ServletContextRequest.getServletContextRequest((ServletRequest)this), pushHeaders, sessionId);
    }

    public Object getAttribute(String name) {
        if (this._async != null) {
            return switch (name) {
                case "jakarta.servlet.async.request_uri" -> this.getRequestURI();
                case "jakarta.servlet.async.context_path" -> this.getContextPath();
                case "jakarta.servlet.async.servlet_path" -> this.getServletPath();
                case "jakarta.servlet.async.path_info" -> this.getPathInfo();
                case "jakarta.servlet.async.query_string" -> this.getQueryString();
                case "jakarta.servlet.async.mapping" -> this.getHttpServletMapping();
                default -> this.getRequest().getAttribute(name);
            };
        }
        return this.getRequest().getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        HashSet<String> set = this.getRequest().getAttributeNameSet();
        if (this._async != null) {
            set = new HashSet<String>(set);
            set.add("jakarta.servlet.async.request_uri");
            set.add("jakarta.servlet.async.context_path");
            set.add("jakarta.servlet.async.servlet_path");
            set.add("jakarta.servlet.async.path_info");
            set.add("jakarta.servlet.async.query_string");
            set.add("jakarta.servlet.async.mapping");
        }
        return Collections.enumeration(set);
    }

    public String getCharacterEncoding() {
        if (this._characterEncoding == null) {
            String contentType;
            if (this.getRequest().getContext() != null) {
                this._characterEncoding = this.getServletRequestInfo().getServletContext().getServletContext().getRequestCharacterEncoding();
            }
            if (this._characterEncoding == null && (contentType = this.getContentType()) != null) {
                String charset;
                MimeTypes.Type mime = (MimeTypes.Type)MimeTypes.CACHE.get(contentType);
                String string = charset = mime == null || mime.getCharset() == null ? MimeTypes.getCharsetFromContentType((String)contentType) : mime.getCharset().toString();
                if (charset != null) {
                    this._characterEncoding = charset;
                }
            }
        }
        return this._characterEncoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            return;
        }
        MimeTypes.getKnownCharset((String)encoding);
        this._characterEncoding = encoding;
    }

    public int getContentLength() {
        long contentLength = this.getContentLengthLong();
        if (contentLength > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)contentLength;
    }

    public long getContentLengthLong() {
        if (this.getFields() == null) {
            return -1L;
        }
        return this.getFields().getLongField(HttpHeader.CONTENT_LENGTH);
    }

    public String getContentType() {
        if (this._contentType == null) {
            this._contentType = this.getFields().get(HttpHeader.CONTENT_TYPE);
        }
        return this._contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        this._inputState = 1;
        if (this.getServletRequestInfo().getServletChannel().isExpecting100Continue()) {
            this.getServletRequestInfo().getServletChannel().continue100(this.getServletRequestInfo().getHttpInput().available());
        }
        return this.getServletRequestInfo().getHttpInput();
    }

    public String getParameter(String name) {
        return this.getParameters().getValue(name);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameters().getNames());
    }

    public String[] getParameterValues(String name) {
        List vals = this.getParameters().getValues(name);
        if (vals == null) {
            return null;
        }
        return vals.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.getParameters().toStringArrayMap());
    }

    private Fields getParameters() {
        this.extractContentParameters();
        this.extractQueryParameters();
        if (ServletContextRequest.isNoParams(this._queryParameters) || this._queryParameters.getSize() == 0) {
            this._parameters = this._contentParameters;
        } else if (ServletContextRequest.isNoParams(this._contentParameters) || this._contentParameters.getSize() == 0) {
            this._parameters = this._queryParameters;
        } else if (this._parameters == null) {
            this._parameters = new Fields(true);
            this._parameters.addAll(this._queryParameters);
            this._parameters.addAll(this._contentParameters);
        }
        Fields parameters = this._parameters;
        return parameters == null ? ServletContextRequest.NO_PARAMS : parameters;
    }

    private void extractContentParameters() throws BadMessageException {
        if (!this._contentParamsExtracted) {
            this._contentParamsExtracted = true;
            if (this._contentParameters == null) {
                try {
                    int contentLength = this.getContentLength();
                    if (contentLength != 0 && this._inputState == 0) {
                        String baseType = HttpField.getValueParameters((String)this.getContentType(), null);
                        if (MimeTypes.Type.FORM_ENCODED.is(baseType) && this.getRequest().getConnectionMetaData().getHttpConfiguration().isFormEncodedMethod(this.getMethod())) {
                            try {
                                ServletContextHandler contextHandler = this.getServletRequestInfo().getServletContextHandler();
                                int maxKeys = contextHandler.getMaxFormKeys();
                                int maxContentSize = contextHandler.getMaxFormContentSize();
                                this._contentParameters = (Fields)FormFields.from((Request)this.getRequest(), (int)maxKeys, (int)maxContentSize).get();
                            }
                            catch (IllegalArgumentException | IllegalStateException | InterruptedException | ExecutionException e) {
                                LOG.warn(e.toString());
                                throw new BadMessageException("Unable to parse form content", (Throwable)e);
                            }
                        }
                        if (MimeTypes.Type.MULTIPART_FORM_DATA.is(baseType) && this.getAttribute("org.eclipse.jetty.multipartConfig") != null) {
                            try {
                                this.getParts();
                            }
                            catch (IOException e) {
                                String msg = "Unable to extract content parameters";
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(msg, (Throwable)e);
                                }
                                throw new RuntimeIOException(msg, (Throwable)e);
                            }
                            catch (ServletException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof BadMessageException) {
                                    BadMessageException badMessageException = (BadMessageException)cause;
                                    throw badMessageException;
                                }
                                String msg = "Unable to extract content parameters";
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(msg, (Throwable)e);
                                }
                                throw new RuntimeIOException(msg, (Throwable)e);
                            }
                        }
                        try {
                            this._contentParameters = (Fields)FormFields.get((Request)this.getRequest()).get();
                        }
                        catch (IllegalArgumentException | IllegalStateException | InterruptedException | ExecutionException e) {
                            LOG.warn(e.toString());
                            throw new BadMessageException("Unable to parse form content", (Throwable)e);
                        }
                    }
                    if (this._contentParameters == null || this._contentParameters.isEmpty()) {
                        this._contentParameters = ServletContextRequest.NO_PARAMS;
                    }
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    LOG.warn(e.toString());
                    throw new BadMessageException("Unable to parse form content", (Throwable)e);
                }
            }
        }
    }

    private void extractQueryParameters() throws BadMessageException {
        if (this._queryParameters == null) {
            HttpURI httpURI = this.getRequest().getHttpURI();
            if (httpURI == null || StringUtil.isEmpty((String)httpURI.getQuery())) {
                this._queryParameters = ServletContextRequest.NO_PARAMS;
            } else {
                try {
                    this._queryParameters = Request.extractQueryParameters((Request)this.getRequest(), (Charset)this.getServletRequestInfo().getQueryEncoding());
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    this._queryParameters = ServletContextRequest.BAD_PARAMS;
                    throw new BadMessageException("Unable to parse URI query", (Throwable)e);
                }
            }
        }
    }

    public String getProtocol() {
        return this.getRequest().getConnectionMetaData().getProtocol();
    }

    public String getScheme() {
        return this.getRequest().getHttpURI().getScheme();
    }

    public String getServerName() {
        HttpURI uri = this.getRequest().getHttpURI();
        if (uri != null && StringUtil.isNotBlank((String)uri.getAuthority())) {
            return this.formatAddrOrHost(uri.getHost());
        }
        return this.findServerName();
    }

    private String formatAddrOrHost(String name) {
        ServletChannel servletChannel = this._servletChannel;
        return servletChannel == null ? HostPort.normalizeHost((String)name) : servletChannel.formatAddrOrHost(name);
    }

    private String findServerName() {
        HostPort serverAuthority;
        ServletChannel servletChannel = this._servletChannel;
        if (servletChannel != null && (serverAuthority = servletChannel.getServerAuthority()) != null) {
            return this.formatAddrOrHost(serverAuthority.getHost());
        }
        String name = this.getLocalName();
        if (name != null) {
            return this.formatAddrOrHost(name);
        }
        return "";
    }

    public int getServerPort() {
        HttpURI uri = this.getRequest().getHttpURI();
        int port = uri != null && StringUtil.isNotBlank((String)uri.getAuthority()) ? uri.getPort() : this.findServerPort();
        if (port <= 0) {
            return HttpScheme.getDefaultPort((String)this.getScheme());
        }
        return port;
    }

    private int findServerPort() {
        HostPort serverAuthority;
        ServletChannel servletChannel = this.getServletRequestInfo().getServletChannel();
        if (servletChannel != null && (serverAuthority = servletChannel.getServerAuthority()) != null) {
            return serverAuthority.getPort();
        }
        return this.getLocalPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._inputState == 2) {
            return this._reader;
        }
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = MimeTypes.ISO_8859_1;
        }
        if (this._reader == null || !encoding.equalsIgnoreCase(this._readerEncoding)) {
            final ServletInputStream in = this.getInputStream();
            this._readerEncoding = encoding;
            this._reader = new BufferedReader(new InputStreamReader((InputStream)in, encoding)){

                @Override
                public void close() throws IOException {
                    in.close();
                }
            };
        } else if (this.getServletRequestInfo().getServletChannel().isExpecting100Continue()) {
            this.getServletRequestInfo().getServletChannel().continue100(this.getServletRequestInfo().getHttpInput().available());
        }
        this._inputState = 2;
        return this._reader;
    }

    public String getRemoteAddr() {
        return Request.getRemoteAddr((Request)this.getRequest());
    }

    public String getRemoteHost() {
        return Request.getRemoteAddr((Request)this.getRequest());
    }

    public void setAttribute(String name, Object attribute) {
        Object oldValue = this.getRequest().setAttribute(name, attribute);
        if ("org.eclipse.jetty.server.Request.queryEncoding".equals(name)) {
            this.getServletRequestInfo().setQueryEncoding(attribute == null ? null : attribute.toString());
        }
        if (!this.getServletRequestInfo().getRequestAttributeListeners().isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.getServletRequestInfo().getServletContext().getServletContext(), (ServletRequest)this, name, oldValue == null ? attribute : oldValue);
            for (ServletRequestAttributeListener l : this.getServletRequestInfo().getRequestAttributeListeners()) {
                if (oldValue == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (attribute == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this.getRequest().removeAttribute(name);
        if (oldValue != null && !this.getServletRequestInfo().getRequestAttributeListeners().isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.getServletRequestInfo().getServletContext().getServletContext(), (ServletRequest)this, name, oldValue);
            for (ServletRequestAttributeListener listener : this.getServletRequestInfo().getRequestAttributeListeners()) {
                listener.attributeRemoved(event);
            }
        }
    }

    public Locale getLocale() {
        return (Locale)Request.getLocales((Request)this.getRequest()).get(0);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Request.getLocales((Request)this.getRequest()));
    }

    public boolean isSecure() {
        return this.getRequest().getConnectionMetaData().isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        ServletContextHandler.ServletScopedContext context = this.getServletRequestInfo().getServletContext();
        if (path == null || context == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            String relTo = this.getServletRequestInfo().getDecodedPathInContext();
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            path = URIUtil.addPaths((String)relTo, (String)path);
        }
        return context.getServletContext().getRequestDispatcher(path);
    }

    public int getRemotePort() {
        return Request.getRemotePort((Request)this.getRequest());
    }

    public String getLocalName() {
        ServletChannel servletChannel = this.getServletRequestInfo().getServletChannel();
        if (servletChannel != null) {
            String localName = servletChannel.getLocalName();
            return this.formatAddrOrHost(localName);
        }
        return "";
    }

    public String getLocalAddr() {
        return Request.getLocalAddr((Request)this.getRequest());
    }

    public int getLocalPort() {
        return Request.getLocalPort((Request)this.getRequest());
    }

    public ServletContext getServletContext() {
        return this.getServletRequestInfo().getServletChannel().getServletContextApi();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("Async Not Supported");
        }
        ServletChannelState state = this.getServletRequestInfo().getState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        ServletContextHandler.ServletRequestInfo servletRequestInfo = this.getServletRequestInfo();
        AsyncContextEvent event = new AsyncContextEvent(this.getServletRequestInfo().getServletContext(), this._async, state, (ServletRequest)this, (ServletResponse)servletRequestInfo.getServletChannel().getServletContextResponse().getServletApiResponse());
        state.startAsync(event);
        return this._async;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("Async Not Supported");
        }
        ServletChannelState state = this.getServletRequestInfo().getState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        AsyncContextEvent event = new AsyncContextEvent(this.getServletRequestInfo().getServletContext(), this._async, state, servletRequest, servletResponse);
        state.startAsync(event);
        return this._async;
    }

    public HttpServletMapping getHttpServletMapping() {
        return ((ServletHandler.MappedServlet)this.getServletRequestInfo().getMatchedResource().getResource()).getServletPathMapping(this.getServletRequestInfo().getDecodedPathInContext());
    }

    public boolean isAsyncStarted() {
        return this.getServletRequestInfo().getState().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this._asyncSupported = asyncSupported;
    }

    public AsyncContext getAsyncContext() {
        ServletChannelState state = this.getServletRequestInfo().getServletChannel().getServletRequestState();
        if (this._async == null || !state.isAsyncStarted()) {
            throw new IllegalStateException(state.getStatusString());
        }
        return this._async;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public Map<String, String> getTrailerFields() {
        HttpFields trailers = this.getRequest().getTrailers();
        if (trailers == null) {
            return Map.of();
        }
        HashMap<String, String> trailersMap = new HashMap<String, String>();
        for (HttpField field : trailers) {
            String key = field.getLowerCaseName();
            trailersMap.merge(key, field.getValue(), (existing, value) -> existing + "," + value);
        }
        return trailersMap;
    }

    private static class ServletCookieList
    extends AbstractList<HttpCookie> {
        private final List<HttpCookie> _httpCookies;
        private final Cookie[] _cookies;

        ServletCookieList(List<HttpCookie> httpCookies, CookieCompliance compliance) {
            this._httpCookies = httpCookies;
            this._cookies = new Cookie[this._httpCookies.size()];
            int i = 0;
            for (HttpCookie httpCookie : this._httpCookies) {
                this._cookies[i++] = ServletCookieList.convertCookie(httpCookie, compliance);
            }
        }

        @Override
        public HttpCookie get(int index) {
            return this._httpCookies.get(index);
        }

        public Cookie[] getServletCookies() {
            return this._cookies;
        }

        @Override
        public int size() {
            return this._cookies.length;
        }

        private static Cookie convertCookie(HttpCookie cookie, CookieCompliance compliance) {
            Cookie result = new Cookie(cookie.getName(), cookie.getValue());
            if (CookieCompliance.RFC2965.equals(compliance)) {
                result.setPath(cookie.getPath());
                result.setDomain(cookie.getDomain());
            }
            return result;
        }
    }

    static class AmbiguousURI
    extends ServletApiRequest {
        protected AmbiguousURI(ServletContextRequest servletContextRequest) {
            super(servletContextRequest);
        }

        @Override
        public String getPathInfo() {
            throw new HttpException.IllegalArgumentException(400, "Ambiguous URI encoding");
        }

        @Override
        public String getServletPath() {
            throw new HttpException.IllegalArgumentException(400, "Ambiguous URI encoding");
        }
    }
}

