/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableCharStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableCharStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableCharArrayStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableCharEmptyStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableCharSingletonStack;

public enum ImmutableCharStackFactoryImpl implements ImmutableCharStackFactory
{
    INSTANCE;


    public ImmutableCharStack empty() {
        return ImmutableCharEmptyStack.INSTANCE;
    }

    public ImmutableCharStack of() {
        return this.empty();
    }

    public ImmutableCharStack with() {
        return this.empty();
    }

    public ImmutableCharStack of(char one) {
        return this.with(one);
    }

    public ImmutableCharStack with(char one) {
        return new ImmutableCharSingletonStack(one);
    }

    public ImmutableCharStack of(char ... items) {
        return this.with(items);
    }

    public ImmutableCharStack with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableCharArrayStack.newStackWith(items);
    }

    public ImmutableCharStack ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public ImmutableCharStack withAll(CharIterable items) {
        if (items instanceof ImmutableCharStack) {
            return (ImmutableCharStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableCharStack ofAllReversed(CharIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableCharStack withAllReversed(CharIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableCharArrayStack.newStackFromTopToBottom(items);
    }
}

