/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.core.base.ValueType;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.accessor.Evaluator;
import org.drools.core.rule.accessor.FieldValue;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.time.Interval;
import org.drools.core.util.TimeIntervalParser;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;

public class OverlapsEvaluatorDefinition
implements EvaluatorDefinition {
    public static final String overlapsOp = Operator.BuiltInOperator.OVERLAPS.getSymbol();
    public static final Operator OVERLAPS = Operator.determineOperator((String)overlapsOp, (boolean)false);
    public static final Operator OVERLAPS_NOT = Operator.determineOperator((String)overlapsOp, (boolean)true);
    private static final String[] SUPPORTED_IDS = new String[]{overlapsOp};
    private Map<String, OverlapsEvaluator> cache = Collections.emptyMap();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        OverlapsEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, OverlapsEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            long[] params = TimeIntervalParser.parse((String)parameterText);
            eval = new OverlapsEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class OverlapsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long minDev;
        private long maxDev;
        private String paramText;

        public OverlapsEvaluator() {
        }

        public OverlapsEvaluator(ValueType type, boolean isNegated, long[] parameters, String paramText) {
            super(type, isNegated ? OVERLAPS_NOT : OVERLAPS);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.minDev = in.readLong();
            this.maxDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.minDev);
            out.writeLong(this.maxDev);
            out.writeObject(this.paramText);
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(Long.MIN_VALUE, 0L);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, ReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
            throw new RuntimeException("The 'overlaps' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(reteEvaluator, left.getObject())) {
                return false;
            }
            long leftStartTS = ((EventFactHandle)left).getStartTimestamp();
            long rightEndTS = ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            long dist = rightEndTS - leftStartTS;
            return this.getOperator().isNegated() ^ (((VariableRestriction.TemporalVariableContextEntry)context).startTS < leftStartTS && rightEndTS < ((EventFactHandle)left).getEndTimestamp() && dist >= this.minDev && dist <= this.maxDev);
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(reteEvaluator, right.getObject())) {
                return false;
            }
            long leftStartTS = ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long rightEndTS = ((EventFactHandle)right).getEndTimestamp();
            long dist = rightEndTS - leftStartTS;
            return this.getOperator().isNegated() ^ (((EventFactHandle)right).getStartTimestamp() < leftStartTS && rightEndTS < ((VariableRestriction.TemporalVariableContextEntry)context).endTS && dist >= this.minDev && dist <= this.maxDev);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, ReadAccessor extractor1, InternalFactHandle handle1, ReadAccessor extractor2, InternalFactHandle handle2) {
            if (extractor1.isNullValue(reteEvaluator, handle1.getObject()) || extractor2.isNullValue(reteEvaluator, handle2.getObject())) {
                return false;
            }
            long startTS = ((EventFactHandle)handle2).getStartTimestamp();
            long endTS = ((EventFactHandle)handle1).getEndTimestamp();
            long dist = endTS - startTS;
            return this.getOperator().isNegated() ^ (((EventFactHandle)handle1).getStartTimestamp() < startTS && endTS < ((EventFactHandle)handle2).getEndTimestamp() && dist >= this.minDev && dist <= this.maxDev);
        }

        @Override
        public String toString() {
            return "overlaps[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.maxDev ^ this.maxDev >>> 32);
            result = 31 * result + (int)(this.minDev ^ this.minDev >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OverlapsEvaluator other = (OverlapsEvaluator)obj;
            return this.maxDev == other.maxDev && this.minDev == other.minDev;
        }

        private void setParameters(long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.minDev = 1L;
                this.maxDev = Long.MAX_VALUE;
            } else if (parameters.length == 1) {
                this.minDev = 1L;
                this.maxDev = parameters[0];
            } else if (parameters.length == 2) {
                this.minDev = parameters[0];
                this.maxDev = parameters[1];
            } else {
                throw new RuntimeException("[Overlaps Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
            }
        }
    }
}

