/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.quarkus.util.deployment;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.drools.codegen.common.AppPaths;

public class QuarkusAppPaths
extends AppPaths {
    private static final Path MUTABLE_JAR_PATH = Paths.get("dev", "app");
    private static final Path CLASSES_PATH = Paths.get("target", "classes");
    private static final Path TEST_CLASSES_PATH = Paths.get("target", "test-classes");

    protected QuarkusAppPaths(Set<Path> projectPaths, Collection<Path> classesPaths, boolean isJar, AppPaths.BuildTool bt, Path outputTarget) {
        super(projectPaths, classesPaths, isJar, bt, "main", outputTarget);
    }

    public static AppPaths from(Path outputTarget, Iterable<Path> paths, AppPaths.BuildTool bt) {
        LinkedHashSet<Path> projectPaths = new LinkedHashSet<Path>();
        ArrayList<Path> classesPaths = new ArrayList<Path>();
        boolean isJar = false;
        for (Path path : paths) {
            PathType pathType = QuarkusAppPaths.getPathType(path);
            switch (pathType) {
                case CLASSES: {
                    classesPaths.add(path);
                    projectPaths.add(path.getParent().getParent());
                    break;
                }
                case TEST_CLASSES: {
                    projectPaths.add(path.getParent().getParent());
                    break;
                }
                case JAR: {
                    isJar = true;
                    classesPaths.add(path);
                    projectPaths.add(path.getParent().getParent());
                    break;
                }
                case MUTABLE_JAR: {
                    return new QuarkusAppPaths(Collections.singleton(path), Collections.singleton(path), false, AppPaths.BuildTool.GRADLE, path);
                }
                case UNKNOWN: {
                    classesPaths.add(path);
                    projectPaths.add(path);
                }
            }
        }
        return new QuarkusAppPaths(projectPaths, classesPaths, isJar, bt, outputTarget);
    }

    private static PathType getPathType(Path archiveLocation) {
        if (archiveLocation.endsWith(MUTABLE_JAR_PATH)) {
            return PathType.MUTABLE_JAR;
        }
        if (archiveLocation.endsWith(CLASSES_PATH)) {
            return PathType.CLASSES;
        }
        if (archiveLocation.endsWith(TEST_CLASSES_PATH)) {
            return PathType.TEST_CLASSES;
        }
        if (archiveLocation.toString().toLowerCase().endsWith(".jar") || archiveLocation.toString().toLowerCase().endsWith(".jar.original")) {
            return PathType.JAR;
        }
        return PathType.UNKNOWN;
    }

    private static enum PathType {
        CLASSES,
        TEST_CLASSES,
        JAR,
        MUTABLE_JAR,
        UNKNOWN;

    }
}

