/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.quarkus.util.deployment;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;

public class GeneratedFileWriter {
    private final Path classesDir;
    private final Path sourcesDir;
    private final Path resourcePath;
    private final Path scaffoldedSourcesDir;
    public static final String DEFAULT_SOURCES_DIR = "generated-sources/kogito/";
    public static final String DEFAULT_RESOURCE_PATH = "generated-resources/kogito/";
    public static final String DEFAULT_SCAFFOLDED_SOURCES_DIR = "src/main/java/";
    public static final String DEFAULT_CLASSES_DIR = "target/classes";

    public GeneratedFileWriter(Path classesDir, Path sourcesDir, Path resourcePath, Path scaffoldedSourcesDir) {
        this.classesDir = classesDir;
        this.sourcesDir = sourcesDir;
        this.resourcePath = resourcePath;
        this.scaffoldedSourcesDir = scaffoldedSourcesDir;
    }

    public void writeAll(Collection<GeneratedFile> generatedFiles) {
        generatedFiles.forEach(this::write);
    }

    public void write(GeneratedFile f) throws UncheckedIOException {
        try {
            GeneratedFileType.Category category = f.category();
            switch (category) {
                case INTERNAL_RESOURCE: 
                case STATIC_HTTP_RESOURCE: 
                case COMPILED_CLASS: {
                    this.writeGeneratedFile(f, this.classesDir);
                    break;
                }
                case SOURCE: {
                    if (f.type().isCustomizable()) {
                        this.writeGeneratedFile(f, this.scaffoldedSourcesDir);
                        break;
                    }
                    this.writeGeneratedFile(f, this.sourcesDir);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Category " + category.name());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Path getClassesDir() {
        return this.classesDir;
    }

    public Path getSourcesDir() {
        return this.sourcesDir;
    }

    public Path getResourcePath() {
        return this.resourcePath;
    }

    public Path getScaffoldedSourcesDir() {
        return this.scaffoldedSourcesDir;
    }

    private void writeGeneratedFile(GeneratedFile f, Path location) throws IOException {
        if (location == null) {
            return;
        }
        Files.write(this.pathOf(location, f.path()), f.contents(), new OpenOption[0]);
    }

    private Path pathOf(Path location, Path end) throws IOException {
        Path path = location.resolve(end);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return path;
    }

    public static class Builder {
        private final String classesDir;
        private final String sourcesDir;
        private final String resourcePath;
        private final String scaffoldedSourcesDir;

        public Builder(String classesDir, String sourcesDir, String resourcesDir, String scaffoldedSourcesDir) {
            this.classesDir = classesDir;
            this.sourcesDir = sourcesDir;
            this.resourcePath = resourcesDir;
            this.scaffoldedSourcesDir = scaffoldedSourcesDir;
        }

        public GeneratedFileWriter build(Path basePath) {
            return new GeneratedFileWriter(basePath.resolve(this.classesDir), basePath.resolve(this.sourcesDir), basePath.resolve(this.resourcePath), basePath.resolve(this.scaffoldedSourcesDir));
        }
    }
}

