/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.repository.file;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.utils.AssertUtils;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.config.api.ConfigEnv;
import org.dromara.hmily.config.api.entity.HmilyFileConfig;
import org.dromara.hmily.repository.spi.HmilyRepository;
import org.dromara.hmily.repository.spi.entity.HmilyParticipant;
import org.dromara.hmily.repository.spi.entity.HmilyParticipantUndo;
import org.dromara.hmily.repository.spi.entity.HmilyTransaction;
import org.dromara.hmily.repository.spi.exception.HmilyRepositoryException;
import org.dromara.hmily.serializer.spi.HmilySerializer;
import org.dromara.hmily.serializer.spi.exception.HmilySerializerException;
import org.dromara.hmily.spi.HmilySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HmilySPI(value="file")
public class FileRepository
implements HmilyRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRepository.class);
    private static final String HMILY_ROOT_TRANSACTION = "hmily";
    private static final String HMILY_TRANSATION_PARTICIPANT = "participant";
    private static final String HMILY_PARTICIPANT_UNDO = "undo";
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static final int HMILY_READ_BYTE_SIZE = 2048;
    private static volatile boolean initialized;
    private HmilySerializer hmilySerializer;
    private String appName;
    private String filePath;

    public void init(String appName) {
        this.appName = appName;
        HmilyFileConfig fileConfig = (HmilyFileConfig)ConfigEnv.getInstance().getConfig(HmilyFileConfig.class);
        this.filePath = StringUtils.isBlank((CharSequence)fileConfig.getPath()) ? System.getProperty("user.home") : fileConfig.getPath();
        Path workPath = Paths.get(this.filePath, new String[0]);
        AssertUtils.notNull((Object)Files.isDirectory(workPath, new LinkOption[0]));
        this.makeDir();
    }

    public void setSerializer(HmilySerializer hmilySerializer) {
        this.hmilySerializer = hmilySerializer;
    }

    public int createHmilyTransaction(HmilyTransaction hmilyTransaction) throws HmilyRepositoryException {
        try {
            boolean exsist = this.isExsist(this.getTransationPath(), hmilyTransaction.getTransId());
            if (!exsist) {
                hmilyTransaction.setCreateTime(new Date());
                hmilyTransaction.setUpdateTime(new Date());
                hmilyTransaction.setAppName(this.appName);
                this.createFile(this.getTransationPath(), HmilyTransaction.class, hmilyTransaction.getTransId(), hmilyTransaction);
            } else {
                String filePath = FileRepository.concatPath(this.getTransationPath(), hmilyTransaction.getTransId());
                this.writeTransactionFile(filePath, HmilyTransaction.class, hmilyTransaction);
            }
            return 1;
        }
        catch (IOException e) {
            throw new HmilyException((Throwable)e);
        }
    }

    public int updateRetryByLock(HmilyTransaction hmilyTransaction) {
        boolean exsist = this.isExsist(this.getTransationPath(), hmilyTransaction.getTransId());
        if (!exsist) {
            return 0;
        }
        String filePath = FileRepository.concatPath(this.getTransationPath(), hmilyTransaction.getTransId());
        return this.writeTransactionFile(filePath, HmilyTransaction.class, hmilyTransaction);
    }

    public HmilyTransaction findByTransId(Long transId) {
        boolean exsist = this.isExsist(this.getTransationPath(), transId);
        if (exsist) {
            return this.readFile(this.getTransationPath(), HmilyTransaction.class, transId);
        }
        return null;
    }

    public List<HmilyTransaction> listLimitByDelay(Date date, int limit) {
        return this.listByFilter(this.getTransationPath(), HmilyTransaction.class, (hmilyTransaction, params) -> {
            Date dateParam = (Date)params[0];
            int limitParam = (Integer)params[1];
            boolean filterResult = dateParam.after(hmilyTransaction.getUpdateTime()) && Objects.equals(this.appName, hmilyTransaction.getAppName()) && limitParam-- > 0;
            params[1] = limitParam;
            return filterResult;
        }, date, limit);
    }

    public int updateHmilyTransactionStatus(Long transId, Integer status) throws HmilyRepositoryException {
        boolean exsist = this.isExsist(this.getTransationPath(), transId);
        if (!exsist) {
            return 0;
        }
        HmilyTransaction hmilyTransaction = this.readFile(this.getTransationPath(), HmilyTransaction.class, transId);
        hmilyTransaction.setStatus(status.intValue());
        String filePath = FileRepository.concatPath(this.getTransationPath(), transId);
        return this.writeTransactionFile(filePath, HmilyTransaction.class, hmilyTransaction);
    }

    public int removeHmilyTransaction(Long transId) {
        try {
            boolean exsist = this.isExsist(this.getTransationPath(), transId);
            if (!exsist) {
                return 0;
            }
            HmilyTransaction hmilyTransaction = this.readFile(this.getTransationPath(), HmilyTransaction.class, transId);
            if (hmilyTransaction == null) {
                return 0;
            }
            boolean delete = this.deleteFile(this.getTransationPath(), transId);
            return delete ? 1 : 0;
        }
        catch (IOException e) {
            LogUtil.error((Logger)LOGGER, (String)"removeHmilyTransaction occur a exception {}", e::getMessage);
            return 0;
        }
    }

    public int removeHmilyTransactionByData(Date date) {
        return this.removeByFilter(this.getTransationPath(), HmilyTransaction.class, (hmilyTransaction, params) -> {
            Date dateParam = (Date)params[0];
            return dateParam.after(hmilyTransaction.getUpdateTime()) && hmilyTransaction.getStatus() == HmilyActionEnum.DELETE.getCode();
        }, date);
    }

    public int createHmilyParticipant(HmilyParticipant hmilyParticipant) throws HmilyRepositoryException {
        try {
            boolean exsist = this.isExsist(this.getParticipantPath(), hmilyParticipant.getTransId());
            if (!exsist) {
                hmilyParticipant.setCreateTime(new Date());
                hmilyParticipant.setUpdateTime(new Date());
                hmilyParticipant.setAppName(this.appName);
                this.createFile(this.getParticipantPath(), HmilyParticipant.class, hmilyParticipant.getParticipantId(), hmilyParticipant);
            } else {
                this.writeParticipantFile(this.getParticipantPath(), HmilyParticipant.class, hmilyParticipant.getParticipantId(), hmilyParticipant.getStatus(), 0);
            }
            return 1;
        }
        catch (IOException e) {
            throw new HmilyException((Throwable)e);
        }
    }

    public List<HmilyParticipant> findHmilyParticipant(Long participantId) {
        return this.listByFilter(this.getParticipantPath(), HmilyParticipant.class, (hmilyParticipant, params) -> {
            Long participantIdParam = (Long)params[0];
            return participantIdParam.compareTo(hmilyParticipant.getParticipantId()) == 0 || hmilyParticipant.getParticipantRefId() != null && participantIdParam.compareTo(hmilyParticipant.getParticipantRefId()) == 0;
        }, participantId);
    }

    public List<HmilyParticipant> listHmilyParticipant(Date date, String transType, int limit) {
        return this.listByFilter(this.getParticipantPath(), HmilyParticipant.class, (hmilyParticipant, params) -> {
            Date dateParam = (Date)params[0];
            String transTypeParam = (String)params[1];
            int limitParam = (Integer)params[2];
            boolean filterResult = dateParam.after(hmilyParticipant.getUpdateTime()) && Objects.equals(this.appName, hmilyParticipant.getAppName()) && Objects.equals(transTypeParam, hmilyParticipant.getTransType()) && hmilyParticipant.getStatus().compareTo(HmilyActionEnum.DELETE.getCode()) != 0 && hmilyParticipant.getStatus().compareTo(HmilyActionEnum.DEATH.getCode()) != 0 && limitParam-- > 0;
            params[2] = limitParam;
            return filterResult;
        }, date, transType, limit);
    }

    public List<HmilyParticipant> listHmilyParticipantByTransId(Long transId) {
        return this.listByFilter(this.getParticipantPath(), HmilyParticipant.class, (hmilyParticipant, params) -> transId.compareTo(hmilyParticipant.getTransId()) == 0, transId);
    }

    public boolean existHmilyParticipantByTransId(Long transId) {
        return this.existByFilter((hmilyParticipant, params) -> {
            Long transIdParam = (Long)params[0];
            return transIdParam.compareTo(hmilyParticipant.getTransId()) == 0;
        }, transId);
    }

    public int updateHmilyParticipantStatus(Long participantId, Integer status) throws HmilyRepositoryException {
        boolean exsist = this.isExsist(this.getParticipantPath(), participantId);
        if (!exsist) {
            return 0;
        }
        return this.writeParticipantFile(this.getParticipantPath(), HmilyParticipant.class, participantId, status, 0);
    }

    public int removeHmilyParticipant(Long participantId) {
        try {
            boolean exsist = this.isExsist(this.getParticipantPath(), participantId);
            if (!exsist) {
                return 0;
            }
            HmilyParticipant hmilyParticipant = this.readFile(this.getParticipantPath(), HmilyParticipant.class, participantId);
            if (hmilyParticipant == null) {
                return 0;
            }
            boolean delete = this.deleteFile(this.getParticipantPath(), participantId);
            return delete ? 1 : 0;
        }
        catch (IOException e) {
            LogUtil.error((Logger)LOGGER, (String)"removeHmilyParticipant occur a exception {}", e::getMessage);
            return 0;
        }
    }

    public int removeHmilyParticipantByData(Date date) {
        return this.removeByFilter(this.getParticipantPath(), HmilyParticipant.class, (hmilyParticipant, params) -> {
            Date dateParam = (Date)params[0];
            return dateParam.after(hmilyParticipant.getUpdateTime()) && Objects.equals(HmilyActionEnum.DELETE.getCode(), hmilyParticipant.getStatus());
        }, date);
    }

    public boolean lockHmilyParticipant(HmilyParticipant hmilyParticipant) {
        int currentVersion = hmilyParticipant.getVersion();
        boolean exsist = this.isExsist(this.getParticipantPath(), hmilyParticipant.getParticipantId());
        if (!exsist) {
            LogUtil.warn((Logger)LOGGER, (String)"path {} is not exists.", () -> this.getParticipantPath());
            return false;
        }
        this.writeParticipantFile(this.getParticipantPath(), HmilyParticipant.class, hmilyParticipant.getParticipantId(), hmilyParticipant.getStatus(), 1);
        return true;
    }

    public int createHmilyParticipantUndo(HmilyParticipantUndo hmilyParticipantUndo) {
        try {
            hmilyParticipantUndo.setCreateTime(new Date());
            hmilyParticipantUndo.setUpdateTime(new Date());
            this.createFile(this.getParticipantUndoPath(), HmilyParticipantUndo.class, hmilyParticipantUndo.getUndoId(), hmilyParticipantUndo);
        }
        catch (IOException e) {
            LogUtil.warn((Logger)LOGGER, (String)"file {} is not exists.", () -> hmilyParticipantUndo.getUndoId());
            return 0;
        }
        return 1;
    }

    public List<HmilyParticipantUndo> findHmilyParticipantUndoByParticipantId(Long participantId) {
        return this.listByFilter(this.getParticipantUndoPath(), HmilyParticipantUndo.class, (undo, params) -> {
            Long participantIdParam = (Long)params[0];
            return participantIdParam.compareTo(undo.getParticipantId()) == 0;
        }, participantId);
    }

    public int removeHmilyParticipantUndo(Long undoId) {
        try {
            boolean exsist = this.isExsist(this.getParticipantUndoPath(), undoId);
            if (!exsist) {
                return 0;
            }
            HmilyParticipantUndo hmilyParticipantUndo = this.readFile(this.getParticipantUndoPath(), HmilyParticipantUndo.class, undoId);
            if (hmilyParticipantUndo == null) {
                return 0;
            }
            boolean delete = this.deleteFile(this.getParticipantUndoPath(), undoId);
            return delete ? 1 : 0;
        }
        catch (IOException e) {
            LogUtil.error((Logger)LOGGER, (String)"removeHmilyParticipantUndo occur a exception {}", e::getMessage);
            return 0;
        }
    }

    public int removeHmilyParticipantUndoByData(Date date) {
        return this.removeByFilter(this.getParticipantUndoPath(), HmilyParticipantUndo.class, (undo, params) -> {
            Date dateParam = (Date)params[0];
            return dateParam.after(undo.getUpdateTime()) && Objects.equals(HmilyActionEnum.DELETE.getCode(), undo.getStatus());
        }, date);
    }

    public int updateHmilyParticipantUndoStatus(Long undoId, Integer status) {
        boolean exsist = this.isExsist(this.getParticipantUndoPath(), undoId);
        if (!exsist) {
            return 0;
        }
        String filePath = FileRepository.concatPath(this.getParticipantUndoPath(), undoId);
        return this.writeParticipantUndoFile(filePath, HmilyParticipantUndo.class, undoId, status);
    }

    private String getTransationPath() {
        return this.filePath + File.separator + HMILY_ROOT_TRANSACTION;
    }

    private String getParticipantPath() {
        return this.getTransationPath() + this.getParticipantPrefix() + HMILY_TRANSATION_PARTICIPANT;
    }

    private String getParticipantUndoPath() {
        return this.getTransationPath() + this.getParticipantPrefix() + HMILY_PARTICIPANT_UNDO;
    }

    private String getParticipantPrefix() {
        return File.separator + this.appName + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeDir() {
        if (initialized) return;
        Class<FileRepository> clazz = FileRepository.class;
        synchronized (FileRepository.class) {
            if (initialized) return;
            File rootPathFile = new File(this.filePath);
            if (!rootPathFile.exists()) {
                boolean result = rootPathFile.mkdir();
                if (!result) {
                    throw new HmilyRuntimeException("cannot create root path, the path to create is:" + this.filePath);
                }
                this.initDir();
                initialized = true;
            } else {
                if (!rootPathFile.isDirectory()) {
                    throw new HmilyRuntimeException("rootPath is not directory");
                }
                this.initDir();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void initDir() {
        File participantUndoFileDir;
        File participantFileDir;
        File transationFileDir = new File(this.getTransationPath());
        if (!transationFileDir.exists()) {
            transationFileDir.getParentFile().mkdirs();
            boolean mkdirs = transationFileDir.mkdirs();
            if (!mkdirs) {
                throw new HmilyRuntimeException("cannot create transationFile path, the path to create is:" + transationFileDir.getAbsolutePath());
            }
        }
        if (!(participantFileDir = new File(this.getParticipantPath())).exists()) {
            participantFileDir.getParentFile().mkdirs();
            boolean mkdirs = participantFileDir.mkdirs();
            if (!mkdirs) {
                throw new HmilyRuntimeException("cannot create participantFile path, the path to create is:" + participantFileDir.getAbsolutePath());
            }
        }
        if (!(participantUndoFileDir = new File(this.getParticipantUndoPath())).exists()) {
            participantUndoFileDir.getParentFile().mkdirs();
            boolean mkdirs = participantUndoFileDir.mkdirs();
            if (!mkdirs) {
                throw new HmilyRuntimeException("cannot create participantUndoFile path, the path to create is:" + participantUndoFileDir.getAbsolutePath());
            }
        }
    }

    private boolean isExsist(String path, Long transId) {
        Path filePath;
        boolean directory = Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0]);
        return directory && (filePath = Paths.get(FileRepository.concatPath(path, transId), new String[0])).toFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void createFile(String absolutePath, Class<T> tClass, Long id, T t) throws IOException {
        String filePath = FileRepository.concatPath(absolutePath, id);
        Files.createFile(Paths.get(filePath, new String[0]), new FileAttribute[0]);
        if (!this.isRead(filePath)) {
            return;
        }
        LOCK.writeLock().lock();
        try {
            byte[] serialize = this.hmilySerializer.serialize(t);
            Files.write(Paths.get(filePath, new String[0]), serialize, StandardOpenOption.WRITE);
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    private boolean deleteFile(String absolutePath, Long id) throws IOException {
        AssertUtils.notNull((Object)id);
        return Files.deleteIfExists(Paths.get(FileRepository.concatPath(absolutePath, id), new String[0]));
    }

    private static String concatPath(String filePath, Long id) {
        return filePath + File.separator + id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private <T> T readFile(String absolutePath, Class<T> clazz, Long id) {
        LOCK.readLock().lock();
        Path path = Paths.get(FileRepository.concatPath(absolutePath, id), new String[0]);
        try {
            Object object;
            Throwable throwable;
            FileChannel inChannel;
            block19: {
                block20: {
                    inChannel = FileChannel.open(path, StandardOpenOption.READ);
                    throwable = null;
                    MappedByteBuffer mappedByteBuffer = inChannel.map(FileChannel.MapMode.READ_ONLY, 0L, inChannel.size());
                    byte[] dst = new byte[(int)inChannel.size()];
                    mappedByteBuffer.get(dst);
                    Object t = this.hmilySerializer.deSerialize(dst, clazz);
                    FileRepository.clean(mappedByteBuffer);
                    object = t;
                    if (inChannel == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        inChannel.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                inChannel.close();
            }
            return (T)object;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (inChannel != null) {
                            if (throwable != null) {
                                try {
                                    inChannel.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                inChannel.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException | HmilySerializerException e) {
                    LogUtil.error((Logger)LOGGER, (String)" read file exception ,because is {}", ((Exception)e)::getMessage);
                    throwable = null;
                    return (T)throwable;
                }
            }
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeTransactionFile(String filePath, Class<HmilyTransaction> clazz, HmilyTransaction hmilyTransaction) {
        if (!this.isRead(filePath)) {
            return 0;
        }
        LOCK.writeLock().lock();
        try {
            byte[] serialize = this.hmilySerializer.serialize((Object)hmilyTransaction);
            Files.write(Paths.get(filePath, new String[0]), serialize, StandardOpenOption.WRITE);
            int n = 1;
            LOCK.writeLock().unlock();
            return n;
        }
        catch (IOException | HmilySerializerException e) {
            try {
                LogUtil.error((Logger)LOGGER, (String)" read file exception ,because is {}", ((Exception)e)::getMessage);
                int n = 0;
                LOCK.writeLock().unlock();
                return n;
            }
            catch (Throwable throwable) {
                LOCK.writeLock().unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeParticipantFile(String absolutePath, Class<HmilyParticipant> clazz, Long participiantId, int status, int retryTimes) {
        String filePath = FileRepository.concatPath(absolutePath, participiantId);
        if (!this.isRead(filePath)) {
            return 0;
        }
        LOCK.readLock().lock();
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            HmilyParticipant hmilyParticipant = (HmilyParticipant)this.hmilySerializer.deSerialize(bytes, clazz);
            hmilyParticipant.setStatus(Integer.valueOf(status));
            hmilyParticipant.setUpdateTime(new Date());
            hmilyParticipant.setVersion(Integer.valueOf(hmilyParticipant.getVersion() + 1));
            hmilyParticipant.setRetry(hmilyParticipant.getRetry() + retryTimes);
            byte[] serialize = this.hmilySerializer.serialize((Object)hmilyParticipant);
            Files.write(Paths.get(filePath, new String[0]), serialize, StandardOpenOption.WRITE);
            int n = 1;
            LOCK.readLock().unlock();
            return n;
        }
        catch (IOException | HmilySerializerException e) {
            try {
                LogUtil.error((Logger)LOGGER, (String)" read file exception ,because is {}", ((Exception)e)::getMessage);
                int n = 0;
                LOCK.readLock().unlock();
                return n;
            }
            catch (Throwable throwable) {
                LOCK.readLock().unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeParticipantUndoFile(String filePath, Class<HmilyParticipantUndo> clazz, Long undoId, int status) {
        if (!this.isRead(filePath)) {
            return 0;
        }
        LOCK.writeLock().lock();
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            HmilyParticipantUndo participantUndo = (HmilyParticipantUndo)this.hmilySerializer.deSerialize(bytes, clazz);
            participantUndo.setStatus(Integer.valueOf(status));
            participantUndo.setUpdateTime(new Date());
            byte[] serialize = this.hmilySerializer.serialize((Object)participantUndo);
            Files.write(Paths.get(filePath, new String[0]), serialize, StandardOpenOption.WRITE);
            int n = 1;
            LOCK.writeLock().unlock();
            return n;
        }
        catch (IOException | HmilySerializerException e) {
            try {
                LogUtil.error((Logger)LOGGER, (String)" read file exception ,because is {}", ((Exception)e)::getMessage);
                int n = 0;
                LOCK.writeLock().unlock();
                return n;
            }
            catch (Throwable throwable) {
                LOCK.writeLock().unlock();
                throw throwable;
            }
        }
    }

    private <T> List<T> listByFilter(String path, Class<T> deserializeClass, Filter<T> filter, Object ... params) {
        try {
            List<Path> list = Files.list(Paths.get(path, new String[0])).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList();
            list.forEach(child -> {
                if (!Files.isDirectory(child, new LinkOption[0]) && this.isRead(child.toString()) && child.toFile().getName().lastIndexOf(".") == -1) {
                    Object t = this.readFile(path, deserializeClass, Long.valueOf(child.toFile().getName()));
                    if (t == null) {
                        return;
                    }
                    if (filter.filter(t, params)) {
                        result.add(t);
                    }
                }
            });
            return result;
        }
        catch (Exception e) {
            LogUtil.error((Logger)LOGGER, (String)"listByFilter occur a exception {}", e::getMessage);
            return Collections.emptyList();
        }
    }

    private <T> boolean existByFilter(Filter<HmilyParticipant> filter, Object ... params) {
        try {
            List<Path> list = Files.list(Paths.get(this.getParticipantPath(), new String[0])).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                return false;
            }
            AtomicBoolean flag = new AtomicBoolean(false);
            list.forEach(child -> {
                if (!flag.get() && !Files.isDirectory(child, new LinkOption[0]) && child.toFile().getName().lastIndexOf(".") == -1) {
                    HmilyParticipant hmilyParticipant = this.readFile(this.getParticipantPath(), HmilyParticipant.class, Long.valueOf(child.toFile().getName()));
                    if (hmilyParticipant == null) {
                        return;
                    }
                    if (filter.filter(hmilyParticipant, params)) {
                        flag.set(true);
                    }
                }
            });
            return flag.get();
        }
        catch (IOException e) {
            return false;
        }
    }

    private <T> int removeByFilter(String filePath, Class<T> deserializeClass, Filter<T> filter, Object ... params) {
        try {
            List<Path> list = Files.list(Paths.get(filePath, new String[0])).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            AtomicInteger counter = new AtomicInteger();
            list.forEach(child -> {
                if (!Files.isDirectory(child, new LinkOption[0]) && child.toFile().getName().lastIndexOf(".") == -1) {
                    Object t = this.readFile(filePath, deserializeClass, Long.parseLong(child.toFile().getName()));
                    if (t == null) {
                        return;
                    }
                    if (filter.filter(t, params)) {
                        try {
                            Files.deleteIfExists(child);
                            counter.incrementAndGet();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            return counter.get();
        }
        catch (IOException e) {
            return 0;
        }
    }

    private boolean isRead(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        return Files.isReadable(path);
    }

    public static void clean(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect() || buffer.capacity() == 0) {
            return;
        }
        FileRepository.invoke(FileRepository.invoke(FileRepository.viewed(buffer), "cleaner", new Class[0]), "clean", new Class[0]);
    }

    private static Object invoke(final Object target, final String methodName, final Class<?> ... args) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = FileRepository.method(target, methodName, args);
                    method.setAccessible(true);
                    return method.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private static Method method(Object target, String methodName, Class<?>[] args) throws NoSuchMethodException {
        try {
            return target.getClass().getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            return target.getClass().getDeclaredMethod(methodName, args);
        }
    }

    private static ByteBuffer viewed(ByteBuffer buffer) {
        ByteBuffer viewedBuffer;
        String methodName = "viewedBuffer";
        Method[] methods = buffer.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("attachment")) continue;
            methodName = "attachment";
            break;
        }
        if ((viewedBuffer = (ByteBuffer)FileRepository.invoke(buffer, methodName, new Class[0])) == null) {
            return buffer;
        }
        return FileRepository.viewed(viewedBuffer);
    }

    static interface Filter<T> {
        public boolean filter(T var1, Object ... var2);
    }
}

