/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql.packet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.ValueObject;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.Reader;
import org.drizzle.jdbc.internal.mysql.MySQLValueObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLRowPacket {
    private final List<ValueObject> columns;

    public MySQLRowPacket(RawPacket rawPacket, List<ColumnInformation> columnInformation) throws IOException {
        this.columns = new ArrayList<ValueObject>(columnInformation.size());
        Reader reader = new Reader(rawPacket);
        boolean readBytes = false;
        for (ColumnInformation currentColumn : columnInformation) {
            MySQLValueObject dvo = new MySQLValueObject(reader.getLengthEncodedBytes(), currentColumn.getType());
            this.columns.add(dvo);
            currentColumn.updateDisplaySize(dvo.getDisplayLength());
        }
    }

    public List<ValueObject> getRow() {
        return this.columns;
    }
}

