/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql;

import java.text.ParseException;
import org.drizzle.jdbc.DrizzleBlob;
import org.drizzle.jdbc.internal.common.AbstractValueObject;
import org.drizzle.jdbc.internal.common.DataType;
import org.drizzle.jdbc.internal.mysql.MySQLType;

public class MySQLValueObject
extends AbstractValueObject {
    public MySQLValueObject(byte[] rawBytes, DataType dataType) {
        super(rawBytes, dataType);
    }

    public Object getObject() throws ParseException {
        if (this.getBytes() == null) {
            return null;
        }
        switch (((MySQLType)this.dataType).getType()) {
            case TINY: {
                return this.getShort();
            }
            case LONG: {
                return this.getLong();
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
            case LONGLONG: {
                return this.getLong();
            }
            case DATETIME: {
                return this.getTimestamp();
            }
            case DATE: {
                return this.getDate();
            }
            case VARCHAR: {
                return this.getString();
            }
            case NEWDECIMAL: {
                return this.getBigDecimal();
            }
            case ENUM: {
                return this.getString();
            }
            case BLOB: {
                return new DrizzleBlob(this.getBytes());
            }
        }
        return null;
    }
}

