/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql;

import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MySQLServerCapabilities {
    LONG_PASSWORD(1),
    FOUND_ROWS(2),
    LONG_FLAG(4),
    CONNECT_WITH_DB(8),
    NO_SCHEMA(16),
    COMPRESS(32),
    ODBC(64),
    LOCAL_FILES(128),
    IGNORE_SPACE(256),
    CLIENT_PROTOCOL_41(512),
    CLIENT_INTERACTIVE(1024),
    SSL(2048),
    IGNORE_SIGPIPE(4096),
    TRANSACTIONS(8192),
    RESERVED(16384),
    SECURE_CONNECTION(Short.MIN_VALUE),
    MULTI_STATEMENTS(0),
    MULTI_RESULTS(0);

    private final short bitmapFlag;

    private MySQLServerCapabilities(short i) {
        this.bitmapFlag = i;
    }

    public static Set<MySQLServerCapabilities> getServerCapabilitiesSet(short i) {
        EnumSet<MySQLServerCapabilities> statusSet = EnumSet.noneOf(MySQLServerCapabilities.class);
        for (MySQLServerCapabilities value : MySQLServerCapabilities.values()) {
            if ((i & value.getBitmapFlag()) != value.getBitmapFlag()) continue;
            statusSet.add(value);
        }
        return statusSet;
    }

    public short getBitmapFlag() {
        return this.bitmapFlag;
    }

    public static short fromSet(Set<MySQLServerCapabilities> capabilities) {
        short retVal = 0;
        for (MySQLServerCapabilities cap : capabilities) {
            retVal = (short)(retVal | cap.getBitmapFlag());
        }
        return retVal;
    }
}

