/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class TimestampParameter
implements ParameterHolder {
    private final byte[] byteRepresentation;

    public TimestampParameter(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.byteRepresentation = String.valueOf("\"" + sdf.format(new Date(timestamp)) + "\"").getBytes();
    }

    public TimestampParameter(long timestamp, Calendar cal) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setCalendar(cal);
        this.byteRepresentation = String.valueOf("\"" + sdf.format(new Date(timestamp)) + "\"").getBytes();
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.byteRepresentation);
    }

    public long length() {
        return this.byteRepresentation.length;
    }
}

