/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class SerializableParameter
implements ParameterHolder {
    private final byte[] rawBytes;
    private final int length;

    public SerializableParameter(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        this.rawBytes = SerializableParameter.escapeBytes(baos.toByteArray());
        this.length = this.rawBytes.length;
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.rawBytes, 0, this.length);
    }

    public long length() {
        return this.length;
    }

    private static byte[] escapeBytes(byte[] input) {
        byte[] buffer = new byte[input.length * 2 + 2];
        int i = 0;
        buffer[i++] = 34;
        for (byte b : input) {
            if (Utils.needsEscaping(b)) {
                buffer[i++] = 92;
            }
            buffer[i++] = b;
        }
        buffer[i++] = 34;
        return Arrays.copyOf(buffer, i);
    }
}

