/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.query.IllegalParameterException;
import org.drizzle.jdbc.internal.common.query.ParameterizedQuery;
import org.drizzle.jdbc.internal.common.query.QueryType;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class DrizzleParameterizedQuery
implements ParameterizedQuery {
    private static final Logger log = Logger.getLogger(DrizzleParameterizedQuery.class.getName());
    private ParameterHolder[] parameters;
    private final int paramCount;
    private final String query;
    private final byte[][] queryPartsArray;

    public DrizzleParameterizedQuery(String query) {
        this.query = query;
        List<String> queryParts = Utils.createQueryParts(query);
        this.queryPartsArray = new byte[queryParts.size()][];
        for (int i = 0; i < queryParts.size(); ++i) {
            this.queryPartsArray[i] = queryParts.get(i).getBytes();
        }
        this.paramCount = queryParts.size() - 1;
        this.parameters = new ParameterHolder[this.paramCount];
    }

    public DrizzleParameterizedQuery(ParameterizedQuery query) {
        this.query = query.getQuery();
        this.queryPartsArray = query.getQueryPartsArray();
        this.paramCount = this.queryPartsArray.length - 1;
        this.parameters = new ParameterHolder[this.paramCount];
    }

    public void setParameter(int position, ParameterHolder parameter) throws IllegalParameterException {
        if (position < 0 || position >= this.paramCount) {
            throw new IllegalParameterException("No '?' on that position");
        }
        this.parameters[position] = parameter;
    }

    public ParameterHolder[] getParameters() {
        return this.parameters;
    }

    public void clearParameters() {
        this.parameters = new ParameterHolder[this.paramCount];
    }

    public int length() throws QueryException {
        if (this.containsNull(this.parameters)) {
            throw new QueryException("You need to set exactly " + this.paramCount + " parameters on the prepared statement");
        }
        int length = 0;
        for (byte[] s : this.queryPartsArray) {
            length += s.length;
        }
        for (ParameterHolder ph : this.parameters) {
            length = (int)((long)length + ph.length());
        }
        return length;
    }

    public void writeTo(OutputStream os) throws IOException, QueryException {
        if (this.containsNull(this.parameters)) {
            throw new QueryException("You need to set exactly " + this.paramCount + " parameters on the prepared statement");
        }
        if (this.queryPartsArray.length == 0) {
            throw new AssertionError((Object)"Invalid query, queryParts was empty");
        }
        os.write(this.queryPartsArray[0]);
        for (int i = 1; i < this.queryPartsArray.length; ++i) {
            this.parameters[i - 1].writeTo(os);
            if (this.queryPartsArray[i].length == 0) continue;
            os.write(this.queryPartsArray[i]);
        }
    }

    private boolean containsNull(ParameterHolder[] parameters) {
        for (ParameterHolder ph : parameters) {
            if (ph != null) continue;
            return true;
        }
        return false;
    }

    public String getQuery() {
        return this.query;
    }

    public byte[][] getQueryPartsArray() {
        return this.queryPartsArray;
    }

    public QueryType getQueryType() {
        return QueryType.classifyQuery(this.query);
    }

    public int getParamCount() {
        return this.paramCount;
    }
}

