/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.packet.CommandPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.WriteBuffer;
import org.drizzle.jdbc.internal.common.query.Query;

public class StreamedQueryPacket
implements CommandPacket {
    private final Query query;

    public StreamedQueryPacket(Query query) {
        this.query = query;
    }

    public void send(OutputStream ostream) throws IOException, QueryException {
        byte[] byteHeader = Arrays.copyOf(WriteBuffer.intToByteArray(this.query.length() + 1), 5);
        byteHeader[3] = 0;
        byteHeader[4] = 3;
        ostream.write(byteHeader);
        this.query.writeTo(ostream);
        ostream.flush();
    }
}

