/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.drizzle.jdbc.internal.common.packet.RawPacket;

public class Reader {
    private final byte packetSeq;
    private final ByteBuffer byteBuffer;

    public Reader(RawPacket rawPacket) {
        this.packetSeq = 0;
        this.byteBuffer = rawPacket.getByteBuffer();
    }

    public String readString(String charset) throws IOException {
        byte ch;
        int cnt = 0;
        byte[] byteArrBuff = new byte[this.byteBuffer.remaining()];
        while (this.byteBuffer.remaining() > 0 && (ch = this.byteBuffer.get()) != 0) {
            byteArrBuff[cnt++] = ch;
        }
        return new String(byteArrBuff, 0, cnt);
    }

    public short readShort() throws IOException {
        return this.byteBuffer.getShort();
    }

    public int readInt() throws IOException {
        return this.byteBuffer.getInt();
    }

    public long readLong() throws IOException {
        return this.byteBuffer.getLong();
    }

    public byte readByte() throws IOException {
        return this.byteBuffer.get();
    }

    public byte[] readRawBytes(int numberOfBytes) throws IOException {
        byte[] tmpArr = new byte[numberOfBytes];
        this.byteBuffer.get(tmpArr, 0, numberOfBytes);
        return tmpArr;
    }

    public void skipByte() throws IOException {
        this.byteBuffer.get();
    }

    public long skipBytes(int bytesToSkip) throws IOException {
        this.byteBuffer.position(this.byteBuffer.position() + bytesToSkip);
        return bytesToSkip;
    }

    public int read24bitword() throws IOException {
        byte[] tmpArr = new byte[3];
        for (int i = 0; i < 3; ++i) {
            tmpArr[i] = this.byteBuffer.get();
        }
        return (tmpArr[0] & 0xFF) + ((tmpArr[1] & 0xFF) << 8) + ((tmpArr[2] & 0xFF) << 16);
    }

    public long getLengthEncodedBinary() throws IOException {
        if (this.byteBuffer.remaining() == 0) {
            return 0L;
        }
        byte type = this.byteBuffer.get();
        if ((type & 0xFF) == 251) {
            return -1L;
        }
        if ((type & 0xFF) == 252) {
            return 0xFFFFL & (long)this.readShort();
        }
        if ((type & 0xFF) == 253) {
            return 0xFFFFFF & this.read24bitword();
        }
        if ((type & 0xFF) == 254) {
            return this.readLong();
        }
        if ((type & 0xFF) <= 250) {
            return 0xFFL & (long)type;
        }
        return 0L;
    }

    public String getLengthEncodedString() throws IOException {
        long encLength = this.getLengthEncodedBinary();
        if (encLength == -1L) {
            return null;
        }
        byte[] tmpBuf = new byte[(int)encLength];
        this.byteBuffer.get(tmpBuf);
        return new String(tmpBuf);
    }

    public byte[] getLengthEncodedBytes() throws IOException {
        long encLength = this.getLengthEncodedBinary();
        if (encLength == -1L) {
            return null;
        }
        byte[] tmpBuf = new byte[(int)encLength];
        this.byteBuffer.get(tmpBuf);
        return tmpBuf;
    }

    public byte getByteAt(int i) throws IOException {
        return this.byteBuffer.get(i);
    }

    public byte getPacketSeq() {
        return this.packetSeq;
    }
}

