/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.drizzle.jdbc.internal.common.DataType;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.ValueObject;

public abstract class AbstractValueObject
implements ValueObject {
    private final byte[] rawBytes;
    protected final DataType dataType;

    protected AbstractValueObject(byte[] rawBytes, DataType dataType) {
        this.dataType = dataType;
        this.rawBytes = rawBytes;
    }

    public String getString() {
        if (this.rawBytes == null) {
            return null;
        }
        return new String(this.rawBytes);
    }

    public long getLong() {
        if (this.rawBytes == null) {
            return 0L;
        }
        return Long.valueOf(this.getString());
    }

    public int getInt() {
        if (this.rawBytes == null) {
            return 0;
        }
        return Integer.valueOf(this.getString());
    }

    public short getShort() {
        if (this.rawBytes == null) {
            return 0;
        }
        return Short.valueOf(this.getString());
    }

    public byte getByte() {
        if (this.rawBytes == null) {
            return 0;
        }
        return Byte.valueOf(this.getString());
    }

    public byte[] getBytes() {
        return this.rawBytes;
    }

    public float getFloat() {
        if (this.rawBytes == null) {
            return 0.0f;
        }
        return Float.valueOf(this.getString()).floatValue();
    }

    public double getDouble() {
        if (this.rawBytes == null) {
            return 0.0;
        }
        return Double.valueOf(this.getString());
    }

    public BigDecimal getBigDecimal() {
        if (this.rawBytes == null) {
            return null;
        }
        return new BigDecimal(this.getString());
    }

    public java.sql.Date getDate() throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date utilDate = sdf.parse(rawValue);
        return new java.sql.Date(utilDate.getTime());
    }

    public Time getTime() {
        if (this.rawBytes == null) {
            return null;
        }
        int packedValue = this.getInt();
        long timestamp = Utils.unpackTime(packedValue);
        return new Time(timestamp);
    }

    public Timestamp getTimestamp() throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = rawValue.length() > 11 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
        Date utilTime = sdf.parse(rawValue);
        return new Timestamp(utilTime.getTime());
    }

    public InputStream getInputStream() {
        if (this.rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.getString().getBytes());
    }

    public InputStream getBinaryInputStream() {
        if (this.rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.rawBytes);
    }

    public abstract Object getObject() throws ParseException;

    public java.sql.Date getDate(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setCalendar(cal);
        Date utilDate = sdf.parse(rawValue);
        return new java.sql.Date(utilDate.getTime());
    }

    public Time getTime(Calendar cal) {
        if (this.rawBytes == null) {
            return null;
        }
        int packedTime = this.getInt();
        long millis = Utils.unpackTime(packedTime);
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setCalendar(cal);
        return new Time(millis);
    }

    public Timestamp getTimestamp(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setCalendar(cal);
        Date utilTime = sdf.parse(rawValue);
        return new Timestamp(utilTime.getTime());
    }

    public boolean getBoolean() {
        if (this.rawBytes == null) {
            return false;
        }
        String rawVal = this.getString();
        return rawVal.equalsIgnoreCase("true") || rawVal.equalsIgnoreCase("1");
    }

    public boolean isNull() {
        return this.rawBytes == null;
    }

    public int getDisplayLength() {
        if (this.rawBytes != null) {
            return this.rawBytes.length;
        }
        return 4;
    }
}

