/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCUrl {
    private final DBType dbType;
    private final String username;
    private final String password;
    private final String hostname;
    private final int port;
    private final String database;

    private JDBCUrl(DBType dbType, String username, String password, String hostname, int port, String database) {
        this.dbType = dbType;
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.database = database;
    }

    public static JDBCUrl parse(String url) {
        Pattern p = Pattern.compile("^jdbc:(drizzle|mysql:thin)://((\\w+)(:(\\w+))?@)?([^/:]+)(:(\\d+))?(/(\\w+))?");
        Matcher m = p.matcher(url);
        if (m.find()) {
            String hostname;
            DBType dbType = m.group(1).equals("mysql:thin") ? DBType.MYSQL : DBType.DRIZZLE;
            String username = m.group(3) == null ? "" : m.group(3);
            String password = m.group(5) == null ? "" : m.group(5);
            String string = hostname = m.group(6) == null ? "" : m.group(6);
            int port = m.group(8) != null ? Integer.parseInt(m.group(8)) : (dbType == DBType.DRIZZLE ? 3306 : 3306);
            String database = m.group(10);
            return new JDBCUrl(dbType, username, password, hostname, port, database);
        }
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBType {
        DRIZZLE,
        MYSQL;

    }
}

