/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.drizzle.jdbc.DrizzleResultSet;
import org.drizzle.jdbc.internal.SQLExceptionMapper;
import org.drizzle.jdbc.internal.common.Protocol;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.query.Query;
import org.drizzle.jdbc.internal.common.query.QueryFactory;
import org.drizzle.jdbc.internal.common.queryresults.ModifyQueryResult;
import org.drizzle.jdbc.internal.common.queryresults.QueryResult;
import org.drizzle.jdbc.internal.common.queryresults.ResultSetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrizzleStatement
implements Statement {
    private final Protocol protocol;
    private ResultSet resultSet;
    private long updateCount;
    private final Connection connection;
    private QueryResult queryResult;
    private boolean warningsCleared;
    private final QueryFactory queryFactory;

    public DrizzleStatement(Protocol protocol, Connection connection, QueryFactory queryFactory) {
        this.protocol = protocol;
        this.connection = connection;
        this.queryFactory = queryFactory;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
            }
            Query queryToSend = this.queryFactory.createQuery(query);
            this.queryResult = this.protocol.executeQuery(queryToSend);
            this.warningsCleared = false;
            return new DrizzleResultSet(this.queryResult, this);
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public int executeUpdate(String query) throws SQLException {
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
            }
            this.warningsCleared = false;
            this.queryResult = this.protocol.executeQuery(this.queryFactory.createQuery(query));
            return (int)((ModifyQueryResult)this.queryResult).getUpdateCount();
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public boolean execute(String query) throws SQLException {
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
            }
            this.queryResult = this.protocol.executeQuery(this.queryFactory.createQuery(query));
            if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
                this.setResultSet(new DrizzleResultSet(this.queryResult, this));
                return true;
            }
            this.setUpdateCount(((ModifyQueryResult)this.queryResult).getUpdateCount());
            return false;
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    public QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    @Override
    public void close() throws SQLException {
        if (this.queryResult != null) {
            this.queryResult.close();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cancel is not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (!this.warningsCleared && this.queryResult != null && this.queryResult.getWarnings() > 0) {
            return new SQLWarning(this.queryResult.getMessage());
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException("Multiple open results not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.queryResult != null && this.queryResult.getResultSetType() == ResultSetType.MODIFY) {
            QueryResult genRes = ((ModifyQueryResult)this.queryResult).getGeneratedKeysResult();
            return new DrizzleResultSet(genRes, this);
        }
        return DrizzleResultSet.EMPTY;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return (int)this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.protocol.addToBatch(this.queryFactory.createQuery(sql));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.protocol.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            List<QueryResult> queryRes = this.protocol.executeBatch();
            int[] retVals = new int[queryRes.size()];
            int i = 0;
            for (QueryResult qr : queryRes) {
                if (qr.getResultSetType() == ResultSetType.MODIFY) {
                    retVals[i++] = (int)((ModifyQueryResult)qr).getUpdateCount();
                    continue;
                }
                retVals[i++] = -2;
            }
            return retVals;
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    protected void setResultSet(DrizzleResultSet drizzleResultSet) {
        this.resultSet = drizzleResultSet;
    }

    protected void setUpdateCount(long updateCount) {
        this.updateCount = updateCount;
    }

    protected QueryResult getQueryResult() {
        return this.queryResult;
    }

    protected void setQueryResult(QueryResult result) {
        this.queryResult = result;
    }
}

