/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.dhatim.fastexcel.reader.DefaultXMLInputFactory;
import org.dhatim.fastexcel.reader.ExcelReaderException;
import org.dhatim.fastexcel.reader.Sheet;
import org.dhatim.fastexcel.reader.SimpleXmlReader;

class OPCPackage
implements AutoCloseable {
    private static final Pattern filenameRegex = Pattern.compile("^(.*/)([^/]+)$");
    private static final Map<String, String> IMPLICIT_NUM_FMTS = new HashMap<String, String>(){
        {
            this.put("1", "0");
            this.put("2", "0.00");
            this.put("3", "#,##0");
            this.put("4", "#,##0.00");
            this.put("9", "0%");
            this.put("10", "0.00%");
            this.put("11", "0.00E+00");
            this.put("12", "# ?/?");
            this.put("13", "# ??/??");
            this.put("14", "mm-dd-yy");
            this.put("15", "d-mmm-yy");
            this.put("16", "d-mmm");
            this.put("17", "mmm-yy");
            this.put("18", "h:mm AM/PM");
            this.put("19", "h:mm:ss AM/PM");
            this.put("20", "h:mm");
            this.put("21", "h:mm:ss");
            this.put("22", "m/d/yy h:mm");
            this.put("37", "#,##0 ;(#,##0)");
            this.put("38", "#,##0 ;[Red](#,##0)");
            this.put("39", "#,##0.00;(#,##0.00)");
            this.put("40", "#,##0.00;[Red](#,##0.00)");
            this.put("45", "mm:ss");
            this.put("46", "[h]:mm:ss");
            this.put("47", "mmss.0");
            this.put("48", "##0.0E+0");
            this.put("49", "@");
        }
    };
    private final ZipFile zip;
    private final Map<String, String> workbookPartsById;
    private final PartEntryNames parts;
    private final List<String> formatIdList;
    private Map<String, String> fmtIdToFmtString;

    private OPCPackage(File zipFile) throws IOException {
        this(zipFile, false);
    }

    private OPCPackage(File zipFile, boolean withFormat) throws IOException {
        this(new ZipFile(zipFile), withFormat);
    }

    private OPCPackage(SeekableInMemoryByteChannel channel, boolean withStyle) throws IOException {
        this(new ZipFile((SeekableByteChannel)channel), withStyle);
    }

    private OPCPackage(ZipFile zip, boolean withFormat) throws IOException {
        try {
            this.zip = zip;
            this.parts = this.extractPartEntriesFromContentTypes();
            this.formatIdList = withFormat ? this.extractFormat(this.parts.style) : Collections.emptyList();
            this.workbookPartsById = this.readWorkbookPartsIds(OPCPackage.relsNameFor(this.parts.workbook));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private static String relsNameFor(String entryName) {
        return filenameRegex.matcher(entryName).replaceFirst("$1_rels/$2.rels");
    }

    private Map<String, String> readWorkbookPartsIds(String workbookRelsEntryName) throws IOException, XMLStreamException {
        String xlFolder = workbookRelsEntryName.substring(0, workbookRelsEntryName.indexOf("_rel"));
        HashMap<String, String> partsIdById = new HashMap<String, String>();
        SimpleXmlReader rels = new SimpleXmlReader(DefaultXMLInputFactory.factory, this.getRequiredEntryContent(workbookRelsEntryName));
        while (rels.goTo("Relationship")) {
            String id = rels.getAttribute("Id");
            String target = rels.getAttribute("Target");
            if (!target.startsWith("/")) {
                target = xlFolder + target;
            }
            partsIdById.put(id, target);
        }
        return partsIdById;
    }

    private PartEntryNames extractPartEntriesFromContentTypes() throws XMLStreamException, IOException {
        PartEntryNames entries = new PartEntryNames();
        String contentTypesXml = "[Content_Types].xml";
        try (SimpleXmlReader reader = new SimpleXmlReader(DefaultXMLInputFactory.factory, this.getRequiredEntryContent("[Content_Types].xml"));){
            while (reader.goTo(() -> reader.isStartElement("Override"))) {
                String contentType = reader.getAttributeRequired("ContentType");
                if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml".equals(contentType) || "application/vnd.ms-excel.sheet.macroEnabled.main+xml".equals(contentType)) {
                    entries.workbook = reader.getAttributeRequired("PartName");
                } else if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml".equals(contentType)) {
                    entries.sharedStrings = reader.getAttributeRequired("PartName");
                } else if ("application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml".equals(contentType)) {
                    entries.style = reader.getAttributeRequired("PartName");
                }
                if (!entries.isFullyFilled()) continue;
                break;
            }
            if (entries.workbook == null) {
                entries.workbook = "/xl/workbook.xml";
            }
        }
        return entries;
    }

    private List<String> extractFormat(String styleXml) throws XMLStreamException, IOException {
        ArrayList<String> fmtIdList = new ArrayList<String>();
        this.fmtIdToFmtString = new HashMap<String, String>();
        try (SimpleXmlReader reader = new SimpleXmlReader(DefaultXMLInputFactory.factory, this.getRequiredEntryContent(styleXml));){
            AtomicBoolean insideCellXfs = new AtomicBoolean(false);
            while (reader.goTo(() -> reader.isStartElement("numFmt") || reader.isStartElement("xf") || reader.isStartElement("cellXfs") || reader.isEndElement("cellXfs"))) {
                if (reader.isStartElement("cellXfs")) {
                    insideCellXfs.set(true);
                } else if (reader.isEndElement("cellXfs")) {
                    insideCellXfs.set(false);
                }
                if ("numFmt".equals(reader.getLocalName())) {
                    String formatCode = reader.getAttributeRequired("formatCode");
                    this.fmtIdToFmtString.put(reader.getAttributeRequired("numFmtId"), formatCode);
                    continue;
                }
                if (!insideCellXfs.get() || !reader.isStartElement("xf")) continue;
                String numFmtId = reader.getAttribute("numFmtId");
                fmtIdList.add(numFmtId);
                if (!IMPLICIT_NUM_FMTS.containsKey(numFmtId)) continue;
                this.fmtIdToFmtString.put(numFmtId, IMPLICIT_NUM_FMTS.get(numFmtId));
            }
        }
        return fmtIdList;
    }

    private InputStream getRequiredEntryContent(String name) throws IOException {
        return Optional.ofNullable(this.getEntryContent(name)).orElseThrow(() -> new ExcelReaderException(name + " not found"));
    }

    static OPCPackage open(File inputFile) throws IOException {
        return OPCPackage.open(inputFile, false);
    }

    static OPCPackage open(File inputFile, boolean withFormat) throws IOException {
        return new OPCPackage(inputFile, withFormat);
    }

    static OPCPackage open(InputStream inputStream) throws IOException {
        return OPCPackage.open(inputStream, false);
    }

    static OPCPackage open(InputStream inputStream, boolean withFormat) throws IOException {
        byte[] compressedBytes = IOUtils.toByteArray((InputStream)inputStream);
        return new OPCPackage(new SeekableInMemoryByteChannel(compressedBytes), withFormat);
    }

    InputStream getSharedStrings() throws IOException {
        return this.getEntryContent(this.parts.sharedStrings);
    }

    private InputStream getEntryContent(String name) throws IOException {
        ZipArchiveEntry entry;
        if (name == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((entry = this.zip.getEntry(name)) == null) {
            Enumeration entries = this.zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry e = (ZipArchiveEntry)entries.nextElement();
                if (!e.getName().equalsIgnoreCase(name)) continue;
                return this.zip.getInputStream(e);
            }
            return null;
        }
        return this.zip.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    public InputStream getWorkbookContent() throws IOException {
        return this.getRequiredEntryContent(this.parts.workbook);
    }

    public InputStream getSheetContent(Sheet sheet) throws IOException {
        String name = this.workbookPartsById.get(sheet.getId());
        if (name == null) {
            String msg = String.format("Sheet#%s '%s' is missing an entry in workbook rels (for id: '%s')", sheet.getIndex(), sheet.getName(), sheet.getId());
            throw new ExcelReaderException(msg);
        }
        return this.getRequiredEntryContent(name);
    }

    public List<String> getFormatList() {
        return this.formatIdList;
    }

    public Map<String, String> getFmtIdToFmtString() {
        return this.fmtIdToFmtString;
    }

    private static class PartEntryNames {
        public static final String WORKBOOK_MAIN_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
        public static final String WORKBOOK_EXCEL_MACRO_ENABLED_MAIN_CONTENT_TYPE = "application/vnd.ms-excel.sheet.macroEnabled.main+xml";
        public static final String SHARED_STRINGS_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
        public static final String STYLE_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml";
        String workbook;
        String sharedStrings;
        String style;

        private PartEntryNames() {
        }

        boolean isFullyFilled() {
            return this.workbook != null && this.sharedStrings != null && this.style != null;
        }
    }
}

