/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.conf;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.datavec.api.util.ReflectionUtils;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;
import org.nd4j.shade.jackson.core.JsonFactory;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Configuration
implements Iterable<Map.Entry<String, String>>,
Writable,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    private boolean quietmode = true;
    private ArrayList<Object> resources = new ArrayList();
    private Set<String> finalParameters = new HashSet<String>();
    private boolean loadDefaults = true;
    private static final WeakHashMap<Configuration, Object> REGISTRY = new WeakHashMap();
    private static final CopyOnWriteArrayList<String> defaultResources = new CopyOnWriteArrayList();
    private static final ConcurrentMap<ClassLoader, Map<String, Class<?>>> CACHE_CLASSES = new ConcurrentHashMap();
    private boolean storeResource;
    private HashMap<String, String> updatingResource;
    private Properties properties;
    private Properties overlay;
    private transient ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static Pattern varPat;

    public Configuration() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(boolean loadDefaults) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.loadDefaults = loadDefaults;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.storeResource = false;
            return;
        }
    }

    private Configuration(Configuration other, boolean storeResource) {
        this(other);
        this.loadDefaults = other.loadDefaults;
        this.storeResource = storeResource;
        if (storeResource) {
            this.updatingResource = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(Configuration other) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.resources = (ArrayList)other.resources.clone();
        Object object = other;
        synchronized (object) {
            if (other.properties != null) {
                this.properties = (Properties)other.properties.clone();
            }
            if (other.overlay != null) {
                this.overlay = (Properties)other.overlay.clone();
            }
        }
        this.finalParameters = new HashSet<String>(other.finalParameters);
        object = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultResource(String name) {
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (defaultResources.contains(name)) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            defaultResources.add(name);
            ArrayList<Configuration> toReload = new ArrayList<Configuration>(REGISTRY.size());
            toReload.addAll(REGISTRY.keySet());
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (Configuration conf : toReload) {
                if (!conf.loadDefaults) continue;
                conf.reloadConfiguration();
            }
            return;
        }
    }

    public void addResource(String name) {
        this.addResourceObject(name);
    }

    public void addResource(URL url) {
        this.addResourceObject(url);
    }

    public void addResource(InputStream in) {
        this.addResourceObject(in);
    }

    public synchronized void reloadConfiguration() {
        this.properties = null;
        this.finalParameters.clear();
    }

    private synchronized void addResourceObject(Object resource) {
        this.resources.add(resource);
        this.reloadConfiguration();
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        Matcher match = varPat.matcher("");
        String eval = expr;
        int MAX_SUBST = 20;
        for (int s = 0; s < MAX_SUBST; ++s) {
            match.reset(eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            var = var.substring(2, var.length() - 1);
            String val = null;
            try {
                val = System.getProperty(var);
            }
            catch (SecurityException se) {
                LOG.warn("Unexpected SecurityException in Configuration", (Throwable)se);
            }
            if (val == null) {
                val = this.getRaw(var);
            }
            if (val == null) {
                return eval;
            }
            eval = eval.substring(0, match.start()) + val + eval.substring(match.end());
        }
        throw new IllegalStateException("Variable substitution depth too large: " + MAX_SUBST + " " + expr);
    }

    public String get(String name) {
        return this.substituteVars(this.getProps().getProperty(name));
    }

    public String getRaw(String name) {
        return this.getProps().getProperty(name);
    }

    public char getChar(String name) {
        return this.getProps().getProperty(name).charAt(0);
    }

    public char getChar(String name, char defaultValue) {
        return this.getProps().getProperty(name, String.valueOf(defaultValue)).charAt(0);
    }

    public void set(String name, String value) {
        this.getOverlay().setProperty(name, value);
        this.getProps().setProperty(name, value);
    }

    public void setIfUnset(String name, String value) {
        if (this.get(name) == null) {
            this.set(name, value);
        }
    }

    private synchronized Properties getOverlay() {
        if (this.overlay == null) {
            this.overlay = new Properties();
        }
        return this.overlay;
    }

    public String get(String name, String defaultValue) {
        return this.substituteVars(this.getProps().getProperty(name, defaultValue));
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Integer.parseInt(hexString, 16);
            }
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Long.parseLong(hexString, 16);
            }
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            String hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public float getFloat(String name, float defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setFloat(String name, float value) {
        this.set(name, Float.toString(value));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.get(name);
        return "true".equals(valueString) || !"false".equals(valueString) && defaultValue;
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public void setBooleanIfUnset(String name, boolean value) {
        this.setIfUnset(name, Boolean.toString(value));
    }

    public Pattern getPattern(String name, Pattern defaultValue) {
        String valString = this.get(name);
        if (null == valString || "".equals(valString)) {
            return defaultValue;
        }
        try {
            return Pattern.compile(valString);
        }
        catch (PatternSyntaxException pse) {
            LOG.warn("Regular expression '" + valString + "' for property '" + name + "' not valid. Using default", (Throwable)pse);
            return defaultValue;
        }
    }

    public void setPattern(String name, Pattern pattern) {
        if (null == pattern) {
            this.set(name, null);
        } else {
            this.set(name, pattern.pattern());
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }

    public IntegerRanges getRange(String name, String defaultValue) {
        return new IntegerRanges(this.get(name, defaultValue));
    }

    public Collection<String> getStringCollection(String name) {
        String valueString = this.get(name);
        if (valueString == null) {
            return null;
        }
        return Arrays.asList(StringUtils.split((String)valueString, (String)","));
    }

    public String[] getStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.split((String)valueString, (String)",");
    }

    public String[] getStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.split((String)valueString, (String)",");
    }

    public Collection<String> getTrimmedStringCollection(String name) {
        String valueString = this.get(name);
        if (null == valueString) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.stripAll((String[])StringUtils.split((String)valueString, (String)",")));
    }

    public String[] getTrimmedStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.stripAll((String[])StringUtils.split((String)valueString, (String)","));
    }

    public String[] getTrimmedStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (null == valueString) {
            return defaultValue;
        }
        return StringUtils.stripAll((String[])StringUtils.split((String)valueString, (String)","));
    }

    public void setStrings(String name, String ... values) {
        this.set(name, StringUtils.join((Object[])values, (String)","));
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        Class<?> clazz;
        ConcurrentHashMap newMap;
        ConcurrentHashMap map = (ConcurrentHashMap)CACHE_CLASSES.get(this.classLoader);
        if (map == null && (map = (Map)CACHE_CLASSES.putIfAbsent(this.classLoader, newMap = new ConcurrentHashMap())) == null) {
            map = newMap;
        }
        if ((clazz = (Class<?>)map.get(name)) == null && (clazz = Class.forName(name, true, this.classLoader)) != null) {
            map.put(name, clazz);
        }
        return clazz;
    }

    public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        String[] classnames = this.getStrings(name);
        if (classnames == null) {
            return defaultValue;
        }
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = this.getClassByName(classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        try {
            Class<?> theClass = this.getClass(name, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <U> List<U> getInstances(String name, Class<U> xface) {
        Class<?>[] classes;
        ArrayList ret = new ArrayList();
        for (Class<?> cl : classes = this.getClasses(name, new Class[0])) {
            if (!xface.isAssignableFrom(cl)) {
                throw new RuntimeException(cl + " does not implement " + xface);
            }
            ret.add(ReflectionUtils.newInstance(cl, this));
        }
        return ret;
    }

    public void setClass(String name, Class<?> theClass, Class<?> xface) {
        if (!xface.isAssignableFrom(theClass)) {
            throw new RuntimeException(theClass + " not " + xface.getName());
        }
        this.set(name, theClass.getName());
    }

    public File getFile(String dirsProp, String path) throws IOException {
        String[] dirs = this.getStrings(dirsProp);
        int hashCode = path.hashCode();
        for (int i = 0; i < dirs.length; ++i) {
            int index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            File file = new File(dirs[index], path);
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) continue;
            return file;
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public InputStream getConfResourceAsInputStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info(name + " not found");
                return null;
            }
            LOG.info("found resource " + name + " at " + url);
            return url.openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Reader getConfResourceAsReader(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info(name + " not found");
                return null;
            }
            LOG.info("found resource " + name + " at " + url);
            return new InputStreamReader(url.openStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    private synchronized Properties getProps() {
        if (this.properties == null) {
            this.properties = new Properties();
            this.loadResources(this.properties, this.resources, this.quietmode);
            if (this.overlay != null) {
                this.properties.putAll((Map<?, ?>)this.overlay);
                if (this.storeResource) {
                    for (Map.Entry<Object, Object> item : this.overlay.entrySet()) {
                        this.updatingResource.put((String)item.getKey(), "Unknown");
                    }
                }
            }
        }
        return this.properties;
    }

    public int size() {
        return this.getProps().size();
    }

    public void clear() {
        this.getProps().clear();
        this.getOverlay().clear();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String)) continue;
            result.put((String)item.getKey(), (String)item.getValue());
        }
        return result.entrySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void loadResources(Properties properties, ArrayList resources, boolean quiet) {
        if (this.loadDefaults) {
            Class<Configuration> clazz = Configuration.class;
            // MONITORENTER : org.datavec.api.conf.Configuration.class
            ArrayList<String> toLoad = new ArrayList<String>(defaultResources);
            // MONITOREXIT : clazz
            for (String resource : toLoad) {
                this.loadResource(properties, resource, quiet);
            }
            if (this.getResource("hadoop-site.xml") != null) {
                this.loadResource(properties, "hadoop-site.xml", quiet);
            }
        }
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            Object resource = iterator.next();
            this.loadResource(properties, resource, quiet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(Properties properties, Object name, boolean quiet) {
        try {
            URL url;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setNamespaceAware(true);
            try {
                docBuilderFactory.setXIncludeAware(true);
            }
            catch (UnsupportedOperationException e) {
                LOG.error("Failed to set setXIncludeAware(true) for parser " + docBuilderFactory + ":" + e, (Throwable)e);
            }
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            Element root = null;
            if (name instanceof URL) {
                url = (URL)name;
                if (url != null) {
                    if (!quiet) {
                        LOG.info("parsing " + url);
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof String) {
                url = this.getResource((String)name);
                if (url != null) {
                    if (!quiet) {
                        LOG.info("parsing " + url);
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof InputStream) {
                try {
                    doc = builder.parse((InputStream)name);
                }
                finally {
                    ((InputStream)name).close();
                }
            } else if (name instanceof Element) {
                root = (Element)name;
            }
            if (doc == null && root == null) {
                if (quiet) {
                    return;
                }
                throw new RuntimeException(name + " not found");
            }
            if (root == null) {
                root = doc.getDocumentElement();
            }
            if (!"configuration".equals(root.getTagName())) {
                LOG.error("bad conf file: top-level element not <configuration>");
            }
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if ("configuration".equals(prop.getTagName())) {
                    this.loadResource(properties, prop, quiet);
                    continue;
                }
                if (!"property".equals(prop.getTagName())) {
                    LOG.warn("bad conf file: element not <property>");
                }
                NodeList fields = prop.getChildNodes();
                String attr = null;
                String value = null;
                boolean finalParameter = false;
                for (int j = 0; j < fields.getLength(); ++j) {
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    Element field = (Element)fieldNode;
                    if ("name".equals(field.getTagName()) && field.hasChildNodes()) {
                        attr = ((Text)field.getFirstChild()).getData().trim();
                    }
                    if ("value".equals(field.getTagName()) && field.hasChildNodes()) {
                        value = ((Text)field.getFirstChild()).getData();
                    }
                    if (!"final".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                    finalParameter = "true".equals(((Text)field.getFirstChild()).getData());
                }
                if (attr == null || value == null) continue;
                if (!this.finalParameters.contains(attr)) {
                    properties.setProperty(attr, value);
                    if (this.storeResource) {
                        this.updatingResource.put(attr, name.toString());
                    }
                    if (!finalParameter) continue;
                    this.finalParameters.add(attr);
                    continue;
                }
                LOG.warn(name + ":a attempt to override final parameter: " + attr + ";  Ignoring.");
            }
        }
        catch (IOException | ParserConfigurationException | DOMException | SAXException e) {
            LOG.error("error parsing conf file: " + e);
            throw new RuntimeException(e);
        }
    }

    public void writeXml(OutputStream out) throws IOException {
        Properties properties = this.getProps();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element conf = doc.createElement("configuration");
            doc.appendChild(conf);
            conf.appendChild(doc.createTextNode("\n"));
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object object = properties.get(name);
                if (!(object instanceof String)) continue;
                String value = (String)object;
                Element propNode = doc.createElement("property");
                conf.appendChild(propNode);
                Element nameNode = doc.createElement("name");
                nameNode.appendChild(doc.createTextNode(name));
                propNode.appendChild(nameNode);
                Element valueNode = doc.createElement("value");
                valueNode.appendChild(doc.createTextNode(value));
                propNode.appendChild(valueNode);
                conf.appendChild(doc.createTextNode("\n"));
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void dumpConfiguration(Configuration conf, Writer out) throws IOException {
        Configuration config = new Configuration(conf, true);
        config.reloadConfiguration();
        JsonFactory dumpFactory = new JsonFactory();
        JsonGenerator dumpGenerator = dumpFactory.createGenerator(out);
        dumpGenerator.writeStartObject();
        dumpGenerator.writeFieldName("properties");
        dumpGenerator.writeStartArray();
        dumpGenerator.flush();
        for (Map.Entry<Object, Object> item : config.getProps().entrySet()) {
            dumpGenerator.writeStartObject();
            dumpGenerator.writeStringField("key", (String)item.getKey());
            dumpGenerator.writeStringField("value", config.get((String)item.getKey()));
            dumpGenerator.writeBooleanField("isFinal", config.finalParameters.contains(item.getKey()));
            dumpGenerator.writeStringField("resource", config.updatingResource.get(item.getKey()));
            dumpGenerator.writeEndObject();
        }
        dumpGenerator.writeEndArray();
        dumpGenerator.writeEndObject();
        dumpGenerator.flush();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration: ");
        if (this.loadDefaults) {
            Class<Configuration> clazz = Configuration.class;
            // MONITORENTER : org.datavec.api.conf.Configuration.class
            this.toString(defaultResources, sb);
            // MONITOREXIT : clazz
            if (this.resources.size() > 0) {
                sb.append(", ");
            }
        }
        this.toString(this.resources, sb);
        return sb.toString();
    }

    private void toString(List resources, StringBuilder sb) {
        ListIterator i = resources.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() != 0) {
                sb.append(", ");
            }
            sb.append(i.next());
        }
    }

    public synchronized void setQuietMode(boolean quietmode) {
        this.quietmode = quietmode;
    }

    public static void main(String[] args) throws Exception {
        new Configuration().writeXml(System.out);
    }

    @Override
    public double toDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float toFloat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int toInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long toLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WritableType getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeType(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    static {
        ClassLoader cL = Thread.currentThread().getContextClassLoader();
        if (cL == null) {
            cL = Configuration.class.getClassLoader();
        }
        if (cL.getResource("hadoop-site.xml") != null) {
            LOG.warn("DEPRECATED: hadoop-site.xml found in the classpath. Usage of hadoop-site.xml is deprecated. Instead use core-site.xml, mapred-site.xml and hdfs-site.xml to override properties of core-default.xml, mapred-default.xml and hdfs-default.xml respectively");
        }
        Configuration.addDefaultResource("core-default.xml");
        Configuration.addDefaultResource("core-site.xml");
        varPat = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
    }

    public static class IntegerRanges {
        List<Range> ranges = new ArrayList<Range>();

        public IntegerRanges() {
        }

        public IntegerRanges(String newValue) {
            StringTokenizer itr = new StringTokenizer(newValue, ",");
            while (itr.hasMoreTokens()) {
                String rng = itr.nextToken().trim();
                String[] parts = rng.split("-", 3);
                if (parts.length < 1 || parts.length > 2) {
                    throw new IllegalArgumentException("integer range badly formed: " + rng);
                }
                Range r = new Range();
                r.start = IntegerRanges.convertToInt(parts[0], 0);
                r.end = parts.length == 2 ? IntegerRanges.convertToInt(parts[1], Integer.MAX_VALUE) : r.start;
                if (r.start > r.end) {
                    throw new IllegalArgumentException("IntegerRange from " + r.start + " to " + r.end + " is invalid");
                }
                this.ranges.add(r);
            }
        }

        private static int convertToInt(String value, int defaultValue) {
            String trim = value.trim();
            if (trim.length() == 0) {
                return defaultValue;
            }
            return Integer.parseInt(trim);
        }

        public boolean isIncluded(int value) {
            for (Range r : this.ranges) {
                if (r.start > value || value > r.end) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Range r : this.ranges) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(r.start);
                result.append('-');
                result.append(r.end);
            }
            return result.toString();
        }

        private static class Range {
            int start;
            int end;

            private Range() {
            }
        }
    }
}

