/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.czeal.rfc3986.Authority;
import org.czeal.rfc3986.FragmentValidator;
import org.czeal.rfc3986.PathValidator;
import org.czeal.rfc3986.QueryValidator;
import org.czeal.rfc3986.SchemeValidator;
import org.czeal.rfc3986.URIReference;
import org.czeal.rfc3986.Utils;

class URIReferenceParser {
    private static final Pattern PATTERN_URI = Pattern.compile("(?<scheme>[^:/?#]+):(\\/\\/(?<authority>[^/?#]*))?(?<path>[^?#]*)(\\?(?<query>[^#]*))?(#(?<fragment>.*))?");
    private static final Pattern PATTERN_REGEX_RELATIVE_REFERENCE = Pattern.compile("(\\/\\/(?<authority>[^/?#]*))?(?<path>[^?#]*)(\\?(?<query>[^#]*))?(#(?<fragment>.*))?");

    URIReferenceParser() {
    }

    URIReference parse(String uriRef, Charset charset) {
        this.validate(uriRef, charset);
        ParseResult res = new ParseResult();
        res.charset = charset;
        this.processInput(res, uriRef);
        this.processAuthority(res);
        this.processPath(res);
        this.processQuery(res);
        this.processFragment(res);
        return res.toURIReference();
    }

    private void validate(String uriRef, Charset charset) {
        if (uriRef == null) {
            throw Utils.newNPE("The input string must not be null.", new Object[0]);
        }
        if (charset == null) {
            throw Utils.newNPE("The charset must not be null.", new Object[0]);
        }
    }

    private void processInput(ParseResult res, String uriRef) {
        String scheme;
        Matcher matcher = PATTERN_URI.matcher(uriRef);
        if (matcher.matches() && this.isSchemeValid(scheme = matcher.group("scheme"))) {
            res.matcher = matcher;
            res.scheme = scheme;
            res.relativeReference = false;
            return;
        }
        this.matchAsRelativeReference(res, uriRef);
    }

    private boolean isSchemeValid(String scheme) {
        try {
            new SchemeValidator().validate(scheme);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private void matchAsRelativeReference(ParseResult res, String uriRef) {
        Matcher matcher = PATTERN_REGEX_RELATIVE_REFERENCE.matcher(uriRef);
        if (!matcher.matches()) {
            throw Utils.newIAE("The input string \"%s\" is invalid as a relative reference.", uriRef);
        }
        res.matcher = matcher;
        res.relativeReference = true;
    }

    private void processAuthority(ParseResult res) {
        String authority = res.matcher.group("authority");
        res.authority = Authority.parse(authority, res.charset);
    }

    private void processPath(ParseResult res) {
        String path = res.matcher.group("path");
        new PathValidator().validate(path, res.charset, res.relativeReference, res.authority != null);
        res.path = path;
    }

    private void processQuery(ParseResult res) {
        String query = res.matcher.group("query");
        new QueryValidator().validate(query, res.charset);
        res.query = query;
    }

    private void processFragment(ParseResult res) {
        String fragment = res.matcher.group("fragment");
        new FragmentValidator().validate(fragment, res.charset);
        res.fragment = fragment;
    }

    private static class ParseResult
    extends URIReference.ProcessResult {
        Matcher matcher;

        private ParseResult() {
        }
    }
}

