/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import org.czeal.rfc3986.AuthorityNormalizer;
import org.czeal.rfc3986.FragmentNormalizer;
import org.czeal.rfc3986.PathNormalizer;
import org.czeal.rfc3986.QueryNormalizer;
import org.czeal.rfc3986.SchemeNormalizer;
import org.czeal.rfc3986.URIReference;
import org.czeal.rfc3986.Utils;

class URIReferenceNormalizer {
    URIReferenceNormalizer() {
    }

    URIReference normalize(URIReference uriRef) {
        this.validate(uriRef);
        URIReference.ProcessResult res = new URIReference.ProcessResult();
        res.charset = uriRef.getCharset();
        res.relativeReference = false;
        this.processScheme(res, uriRef);
        this.processAuthority(res, uriRef);
        this.processPath(res, uriRef);
        this.processQuery(res, uriRef);
        this.processFragment(res, uriRef);
        return res.toURIReference();
    }

    private void validate(URIReference uriRef) {
        if (uriRef == null) {
            throw Utils.newNPE("The URI reference must not be null.", new Object[0]);
        }
        if (uriRef.isRelativeReference()) {
            throw Utils.newISE("A relative references must be resolved before it can be normalized.", new Object[0]);
        }
    }

    private void processScheme(URIReference.ProcessResult res, URIReference uriRef) {
        res.scheme = new SchemeNormalizer().normalize(uriRef.getScheme());
    }

    private void processAuthority(URIReference.ProcessResult res, URIReference uriRef) {
        res.authority = new AuthorityNormalizer().normalize(uriRef.getAuthority(), uriRef.getCharset(), res.scheme);
    }

    private void processPath(URIReference.ProcessResult res, URIReference uriRef) {
        res.path = new PathNormalizer().normalize(uriRef.getPath(), uriRef.getCharset(), uriRef.hasAuthority());
    }

    private void processQuery(URIReference.ProcessResult res, URIReference uriRef) {
        res.query = new QueryNormalizer().normalize(uriRef.getQuery(), uriRef.getCharset());
    }

    private void processFragment(URIReference.ProcessResult res, URIReference uriRef) {
        res.fragment = new FragmentNormalizer().normalize(uriRef.getFragment(), uriRef.getCharset());
    }
}

