/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.czeal.rfc3986.PercentEncodedStringProcessor;
import org.czeal.rfc3986.Utils;

abstract class PercentEncodedStringValidator
extends PercentEncodedStringProcessor {
    protected final String name;

    protected PercentEncodedStringValidator(String name) {
        this.name = name;
    }

    @Override
    protected void onDecoded(Charset charset, StringBuilder outputBuilder, CharBuffer buffer) {
    }

    @Override
    protected void onNonPercent(String input, StringBuilder outputBuilder, char c, int index) {
        if (!this.isValidOnNonPercent(c)) {
            throw Utils.newIAE("The %s value \"%s\" has an invalid character \"%s\" at the index %d.", this.name, input, Character.valueOf(c), index);
        }
    }

    @Override
    protected IllegalArgumentException onMalformedPercentEncodedValue(String input, int index) {
        throw Utils.newIAE("The percent symbol \"%%\" at the index %d in the %s value \"%s\" is not followed by two characters.", index, this.name, input);
    }

    @Override
    protected IllegalArgumentException onInvalidHexDigit(String input, char hexDigit, int index) {
        throw Utils.newIAE("The %s value \"%s\" has an invalid hex digit \"%c\" at the index %d.", this.name, input, Character.valueOf(hexDigit), index);
    }

    @Override
    protected IllegalArgumentException onDecodeFailed(String input, PercentEncodedStringProcessor.Info info) {
        throw Utils.newIAE("Failed to decode bytes represented by \"%s\" in the %s value \"%s\".", info.getString(), this.name, input);
    }

    protected abstract boolean isValidOnNonPercent(char var1);
}

