/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.czeal.rfc3986.PercentEncodedStringProcessor;
import org.czeal.rfc3986.Utils;

class PercentDecoder
extends PercentEncodedStringProcessor {
    static String decode(String input, Charset charset) {
        return new PercentDecoder().process(input, charset);
    }

    private PercentDecoder() {
    }

    private String process(String input, Charset charset) {
        this.validate(input, charset);
        return this.process(input, charset, new StringBuilder());
    }

    private void validate(String input, Charset charset) {
        if (input == null) {
            throw Utils.newNPE("A input must not be null.", new Object[0]);
        }
        if (charset == null) {
            throw Utils.newNPE("A charset must not be null.", new Object[0]);
        }
    }

    @Override
    protected void onDecoded(Charset charset, StringBuilder outputBuilder, CharBuffer buffer) {
        outputBuilder.append(buffer);
    }

    @Override
    protected void onNonPercent(String input, StringBuilder outputBuilder, char c, int index) {
        outputBuilder.append(c);
    }

    @Override
    protected IllegalArgumentException onMalformedPercentEncodedValue(String input, int index) {
        return Utils.newIAE("The percent symbol \"%%\" at the index %d in the input value \"%s\" is not followed by two characters.", index, input);
    }

    @Override
    protected IllegalArgumentException onInvalidHexDigit(String input, char hexDigit, int index) {
        return Utils.newIAE("The character \"%s\" at the index %d in the value \"%s\" is invalid as a hex digit.", Character.valueOf(hexDigit), index, input);
    }

    @Override
    protected IllegalArgumentException onDecodeFailed(String input, PercentEncodedStringProcessor.Info info) {
        return Utils.newIAE("Failed to decode \"%s\" in the value \"%s\".", info.getString(), input);
    }
}

