/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import org.czeal.rfc3986.Utils;

class IpvFutureValidator {
    IpvFutureValidator() {
    }

    void validate(String ipvFuture) {
        if (ipvFuture.isEmpty()) {
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPvFuture address as it is empty.", ipvFuture);
        }
        String[] segments = ipvFuture.split("\\.", 2);
        if (segments.length == 1) {
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPvFuture address due to missing periods.", ipvFuture);
        }
        this.validateFirstSegmentOfIpvFuture(ipvFuture, segments[0]);
        this.validateSecondSegmentOfIpvFuture(ipvFuture, segments[1]);
    }

    private void validateFirstSegmentOfIpvFuture(String enclosed, String firstSegment) {
        boolean isValid;
        boolean bl = isValid = firstSegment.startsWith("v") || firstSegment.startsWith("V");
        if (!isValid) {
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPvFuture address due to missing a version indicator 'v' (or 'V').", enclosed);
        }
        String version = firstSegment.substring(1);
        if (version.isEmpty()) {
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPvFuture address due to missing its version.", enclosed);
        }
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (Utils.isHexDigit(c)) continue;
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPvFuture address due to an invalid version \"%s\", containing an invalid character \"%s\" at the index %d.", enclosed, version, Character.valueOf(c), i);
        }
    }

    private void validateSecondSegmentOfIpvFuture(String enclosed, String secondSegment) {
        if (secondSegment.isEmpty()) {
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPvFuture address as there is no content following the first period.", enclosed);
        }
        for (int i = 0; i < secondSegment.length(); ++i) {
            char c = secondSegment.charAt(i);
            if (Utils.isUnreserved(c) || Utils.isSubdelim(c) || c == ':') continue;
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPvFuture address due to the segment after the first period \"%s\", containing an invalid character \"%c\" at the index %d.", enclosed, secondSegment, Character.valueOf(c), i);
        }
    }
}

