/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.util.Arrays;
import org.czeal.rfc3986.Ipv4AddressValidator;
import org.czeal.rfc3986.Utils;

class Ipv6AddressValidator {
    private static final int MAX_BITS = 112;

    Ipv6AddressValidator() {
    }

    void validate(String ipv6Address) {
        String[] parts = ipv6Address.split("::", 2);
        if (parts.length == 1) {
            this.validateIpv6WithoutDoubleColons(ipv6Address);
            return;
        }
        if (parts.length == 2) {
            this.validateIpv6WithDoubleColons(parts[0], parts[1], ipv6Address);
            return;
        }
    }

    private void validateIpv6WithoutDoubleColons(String ipv6Address) {
        String[] segments = ipv6Address.split(":", -1);
        if (segments.length == 7) {
            this.validateH16Array(Arrays.copyOfRange(segments, 0, 6), ipv6Address);
            this.validate(segments[6]);
            return;
        }
        if (segments.length == 8) {
            this.validateH16Array(segments, ipv6Address);
            return;
        }
        throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPv6 address due to an incorrect number of segments.", ipv6Address);
    }

    private void validateIpv6WithDoubleColons(String valueBeforeDoubleColons, String valueAfterDoubleColons, String value) {
        int bitsAfterDoubleColons;
        int bitsBeforeDoubleColons = this.checkValueBeforeDoubleColons(valueBeforeDoubleColons, value);
        int totalBits = bitsBeforeDoubleColons + (bitsAfterDoubleColons = this.checkValueAfterDoubleColons(valueAfterDoubleColons, value));
        if (totalBits > 112) {
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPv6 address, exceeding the maximum limit of 128 bits.", value);
        }
    }

    private int checkValueBeforeDoubleColons(String value, String enclosed) {
        if (value.isEmpty()) {
            return 0;
        }
        String[] segments = value.split(":", -1);
        this.validateH16Array(segments, enclosed);
        return 16 * segments.length;
    }

    private int checkValueAfterDoubleColons(String part, String enclosed) {
        if (part.isEmpty()) {
            return 0;
        }
        String[] segments = part.split(":", -1);
        try {
            this.validateH16Array(segments, enclosed);
            return 16 * segments.length;
        }
        catch (IllegalArgumentException e) {
            this.validateH16Array(Arrays.copyOfRange(segments, 0, segments.length - 1), enclosed);
            new Ipv4AddressValidator().validate(segments[segments.length - 1]);
            return 16 * (segments.length - 1) + 32;
        }
    }

    private void validateH16Array(String[] segments, String enclosed) {
        for (int i = 0; i < segments.length; ++i) {
            this.validateH16(segments[i], enclosed);
        }
    }

    private void validateH16(String segment, String enclosed) {
        if (segment.isEmpty()) {
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPv6 address due to an empty segment.", enclosed);
        }
        if (segment.length() > 4) {
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPv6 address due to the segment \"%s\" exceeding the maximum limit of 4 characters.", enclosed, segment);
        }
        for (int i = 0; i < segment.length(); ++i) {
            char c = segment.charAt(i);
            if (Utils.isHexDigit(c)) continue;
            throw Utils.newIAE("The host value \"[%s]\" is invalid because the content enclosed by brackets does not form a valid IPv6 address due to the segment \"%s\", containing an invalid character \"%s\" at the index %d.", enclosed, segment, Character.valueOf(c), i);
        }
    }
}

