/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.codelibs.jcifs.smb1.http.NtlmHttpURLConnection;

public class Handler
extends URLStreamHandler {
    public static final int DEFAULT_HTTP_PORT = 80;
    private static final Map PROTOCOL_HANDLERS = new HashMap();
    private static final String HANDLER_PKGS_PROPERTY = "java.protocol.handler.pkgs";
    private static final String[] JVM_VENDOR_DEFAULT_PKGS = new String[]{"sun.net.www.protocol"};
    private static URLStreamHandlerFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory factory) {
        Map map = PROTOCOL_HANDLERS;
        synchronized (map) {
            if (Handler.factory != null) {
                throw new IllegalStateException("URLStreamHandlerFactory already set.");
            }
            PROTOCOL_HANDLERS.clear();
            Handler.factory = factory;
        }
    }

    @Override
    protected int getDefaultPort() {
        return 80;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        url = new URL(url, url.toExternalForm(), Handler.getDefaultStreamHandler(url.getProtocol()));
        return new NtlmHttpURLConnection((HttpURLConnection)url.openConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URLStreamHandler getDefaultStreamHandler(String protocol) throws IOException {
        Map map = PROTOCOL_HANDLERS;
        synchronized (map) {
            URLStreamHandler handler = (URLStreamHandler)PROTOCOL_HANDLERS.get(protocol);
            if (handler != null) {
                return handler;
            }
            if (factory != null) {
                handler = factory.createURLStreamHandler(protocol);
            }
            if (handler == null) {
                String path = System.getProperty(HANDLER_PKGS_PROPERTY);
                StringTokenizer tokenizer = new StringTokenizer(path, "|");
                while (tokenizer.hasMoreTokens()) {
                    String provider = tokenizer.nextToken().trim();
                    if (provider.equals("jcifs.")) continue;
                    String className = provider + "." + protocol + ".Handler";
                    try {
                        Class<?> handlerClass = null;
                        try {
                            handlerClass = Class.forName(className);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (handlerClass == null) {
                            handlerClass = ClassLoader.getSystemClassLoader().loadClass(className);
                        }
                        handler = (URLStreamHandler)handlerClass.newInstance();
                        break;
                    }
                    catch (Exception handlerClass) {
                    }
                }
            }
            if (handler == null) {
                for (String element : JVM_VENDOR_DEFAULT_PKGS) {
                    String className = element + "." + protocol + ".Handler";
                    try {
                        Class<?> handlerClass = null;
                        try {
                            handlerClass = Class.forName(className);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (handlerClass == null) {
                            handlerClass = ClassLoader.getSystemClassLoader().loadClass(className);
                        }
                        handler = (URLStreamHandler)handlerClass.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (handler != null) break;
                }
            }
            if (handler == null) {
                throw new IOException("Unable to find default handler for protocol: " + protocol);
            }
            PROTOCOL_HANDLERS.put(protocol, handler);
            return handler;
        }
    }
}

