/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import org.codelibs.jcifs.smb1.SmbComTransaction;
import org.codelibs.jcifs.smb1.util.LogStream;

class TransTransactNamedPipe
extends SmbComTransaction {
    private final byte[] pipeData;
    private final int pipeFid;
    private final int pipeDataOff;
    private final int pipeDataLen;

    TransTransactNamedPipe(int fid, byte[] data, int off, int len) {
        this.pipeFid = fid;
        this.pipeData = data;
        this.pipeDataOff = off;
        this.pipeDataLen = len;
        this.command = (byte)37;
        this.subCommand = (byte)38;
        this.maxParameterCount = 0;
        this.maxDataCount = 65535;
        this.maxSetupCount = 0;
        this.setupCount = 2;
        this.name = "\\PIPE\\";
    }

    @Override
    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex] = this.subCommand;
        int n = ++dstIndex;
        dst[n] = 0;
        TransTransactNamedPipe.writeInt2(this.pipeFid, dst, ++dstIndex);
        dstIndex += 2;
        return 4;
    }

    @Override
    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int writeDataWireFormat(byte[] dst, int dstIndex) {
        if (dst.length - dstIndex < this.pipeDataLen) {
            if (LogStream.level >= 3) {
                log.println("TransTransactNamedPipe data too long for buffer");
            }
            return 0;
        }
        System.arraycopy(this.pipeData, this.pipeDataOff, dst, dstIndex, this.pipeDataLen);
        return this.pipeDataLen;
    }

    @Override
    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return "TransTransactNamedPipe[" + super.toString() + ",pipeFid=" + this.pipeFid + "]";
    }
}

