/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import org.codelibs.jcifs.smb1.SmbComTransaction;
import org.codelibs.jcifs.smb1.util.Hexdump;

class Trans2QueryFSInformation
extends SmbComTransaction {
    private final int informationLevel;

    Trans2QueryFSInformation(int informationLevel) {
        this.command = (byte)50;
        this.subCommand = (byte)3;
        this.informationLevel = informationLevel;
        this.totalParameterCount = 2;
        this.totalDataCount = 0;
        this.maxParameterCount = 0;
        this.maxDataCount = 800;
        this.maxSetupCount = 0;
    }

    @Override
    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex] = this.subCommand;
        int n = ++dstIndex;
        ++dstIndex;
        dst[n] = 0;
        return 2;
    }

    @Override
    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        Trans2QueryFSInformation.writeInt2(this.informationLevel, dst, dstIndex);
        return (dstIndex += 2) - start;
    }

    @Override
    int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return "Trans2QueryFSInformation[" + super.toString() + ",informationLevel=0x" + Hexdump.toHexString(this.informationLevel, 3) + "]";
    }
}

