/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import java.util.Enumeration;
import org.codelibs.jcifs.smb1.FileEntry;
import org.codelibs.jcifs.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb1.util.LogStream;

abstract class SmbComTransactionResponse
extends ServerMessageBlock
implements Enumeration {
    private static final int SETUP_OFFSET = 61;
    private static final int DISCONNECT_TID = 1;
    private static final int ONE_WAY_TRANSACTION = 2;
    private int pad;
    private int pad1;
    private boolean parametersDone;
    private boolean dataDone;
    protected int totalParameterCount;
    protected int totalDataCount;
    protected int parameterCount;
    protected int parameterOffset;
    protected int parameterDisplacement;
    protected int dataOffset;
    protected int dataDisplacement;
    protected int setupCount;
    protected int bufParameterStart;
    protected int bufDataStart;
    int dataCount;
    byte subCommand;
    boolean hasMore = true;
    boolean isPrimary = true;
    byte[] txn_buf = null;
    int status;
    int numEntries;
    FileEntry[] results;

    SmbComTransactionResponse() {
    }

    @Override
    void reset() {
        super.reset();
        this.bufDataStart = 0;
        this.hasMore = true;
        this.isPrimary = true;
        this.dataDone = false;
        this.parametersDone = false;
    }

    @Override
    public boolean hasMoreElements() {
        return this.errorCode == 0 && this.hasMore;
    }

    public Object nextElement() {
        if (this.isPrimary) {
            this.isPrimary = false;
        }
        return this;
    }

    @Override
    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.totalParameterCount = SmbComTransactionResponse.readInt2(buffer, bufferIndex);
        if (this.bufDataStart == 0) {
            this.bufDataStart = this.totalParameterCount;
        }
        this.totalDataCount = SmbComTransactionResponse.readInt2(buffer, bufferIndex += 2);
        this.parameterCount = SmbComTransactionResponse.readInt2(buffer, bufferIndex += 4);
        this.parameterOffset = SmbComTransactionResponse.readInt2(buffer, bufferIndex += 2);
        this.parameterDisplacement = SmbComTransactionResponse.readInt2(buffer, bufferIndex += 2);
        this.dataCount = SmbComTransactionResponse.readInt2(buffer, bufferIndex += 2);
        this.dataOffset = SmbComTransactionResponse.readInt2(buffer, bufferIndex += 2);
        this.dataDisplacement = SmbComTransactionResponse.readInt2(buffer, bufferIndex += 2);
        this.setupCount = buffer[bufferIndex += 2] & 0xFF;
        bufferIndex += 2;
        if (this.setupCount != 0 && LogStream.level > 2) {
            log.println("setupCount is not zero: " + this.setupCount);
        }
        return bufferIndex - start;
    }

    @Override
    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        this.pad1 = 0;
        this.pad = 0;
        if (this.parameterCount > 0) {
            this.pad = this.parameterOffset - (bufferIndex - this.headerStart);
            System.arraycopy(buffer, bufferIndex += this.pad, this.txn_buf, this.bufParameterStart + this.parameterDisplacement, this.parameterCount);
            bufferIndex += this.parameterCount;
        }
        if (this.dataCount > 0) {
            this.pad1 = this.dataOffset - (bufferIndex - this.headerStart);
            System.arraycopy(buffer, bufferIndex += this.pad1, this.txn_buf, this.bufDataStart + this.dataDisplacement, this.dataCount);
            bufferIndex += this.dataCount;
        }
        if (!this.parametersDone && this.parameterDisplacement + this.parameterCount == this.totalParameterCount) {
            this.parametersDone = true;
        }
        if (!this.dataDone && this.dataDisplacement + this.dataCount == this.totalDataCount) {
            this.dataDone = true;
        }
        if (this.parametersDone && this.dataDone) {
            this.hasMore = false;
            this.readParametersWireFormat(this.txn_buf, this.bufParameterStart, this.totalParameterCount);
            this.readDataWireFormat(this.txn_buf, this.bufDataStart, this.totalDataCount);
        }
        return this.pad + this.parameterCount + this.pad1 + this.dataCount;
    }

    abstract int writeSetupWireFormat(byte[] var1, int var2);

    abstract int writeParametersWireFormat(byte[] var1, int var2);

    abstract int writeDataWireFormat(byte[] var1, int var2);

    abstract int readSetupWireFormat(byte[] var1, int var2, int var3);

    abstract int readParametersWireFormat(byte[] var1, int var2, int var3);

    abstract int readDataWireFormat(byte[] var1, int var2, int var3);

    @Override
    public String toString() {
        return super.toString() + ",totalParameterCount=" + this.totalParameterCount + ",totalDataCount=" + this.totalDataCount + ",parameterCount=" + this.parameterCount + ",parameterOffset=" + this.parameterOffset + ",parameterDisplacement=" + this.parameterDisplacement + ",dataCount=" + this.dataCount + ",dataOffset=" + this.dataOffset + ",dataDisplacement=" + this.dataDisplacement + ",setupCount=" + this.setupCount + ",pad=" + this.pad + ",pad1=" + this.pad1;
    }
}

