/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import java.io.IOException;
import org.codelibs.jcifs.smb1.ACE;
import org.codelibs.jcifs.smb1.SID;
import org.codelibs.jcifs.smb1.ServerMessageBlock;

public class SecurityDescriptor {
    SID owner_user;
    SID owner_group;
    public int type;
    public ACE[] aces;

    public SecurityDescriptor() {
    }

    public SecurityDescriptor(byte[] buffer, int bufferIndex, int len) throws IOException {
        this.decode(buffer, bufferIndex, len);
    }

    public int decode(byte[] buffer, int bufferIndex, int len) throws IOException {
        int start = bufferIndex++;
        this.type = ServerMessageBlock.readInt2(buffer, ++bufferIndex);
        int ownerUOffset = ServerMessageBlock.readInt4(buffer, bufferIndex += 2);
        int ownerGOffset = ServerMessageBlock.readInt4(buffer, bufferIndex += 4);
        int saclOffset = ServerMessageBlock.readInt4(buffer, bufferIndex += 4);
        int daclOffset = ServerMessageBlock.readInt4(buffer, bufferIndex += 4);
        if (ownerUOffset > 0) {
            bufferIndex = start + ownerUOffset;
            this.owner_user = new SID(buffer, bufferIndex);
            bufferIndex += 28;
        }
        if (ownerGOffset > 0) {
            bufferIndex = start + ownerGOffset;
            this.owner_group = new SID(buffer, bufferIndex);
            bufferIndex += 28;
        }
        bufferIndex = start + daclOffset;
        if (daclOffset != 0) {
            ++bufferIndex;
            int size = ServerMessageBlock.readInt2(buffer, ++bufferIndex);
            int numAces = ServerMessageBlock.readInt4(buffer, bufferIndex += 2);
            bufferIndex += 4;
            if (numAces > 4096) {
                throw new IOException("Invalid SecurityDescriptor");
            }
            this.aces = new ACE[numAces];
            for (int i = 0; i < numAces; ++i) {
                this.aces[i] = new ACE();
                bufferIndex += this.aces[i].decode(buffer, bufferIndex);
            }
        } else {
            this.aces = null;
        }
        return bufferIndex - start;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("SecurityDescriptor:\n");
        if (this.aces != null) {
            for (ACE element : this.aces) {
                ret.append(element.toString()).append("\n");
            }
        } else {
            ret.append("NULL");
        }
        return ret.toString();
    }
}

