/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.codelibs.jcifs.smb1.SmbFile;

public class Handler
extends URLStreamHandler {
    static final URLStreamHandler SMB_HANDLER = new Handler();

    @Override
    protected int getDefaultPort() {
        return 445;
    }

    @Override
    public URLConnection openConnection(URL u) throws IOException {
        return new SmbFile(u);
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        int port;
        String host = u.getHost();
        if (((String)spec).equals("smb1://")) {
            spec = "smb1:////";
            limit += 2;
        } else if (!((String)spec).startsWith("smb1://") && host != null && host.length() == 0) {
            spec = "//" + (String)spec;
            limit += 2;
        }
        super.parseURL(u, (String)spec, start, limit);
        Object path = u.getPath();
        String ref = u.getRef();
        if (ref != null) {
            path = (String)path + "#" + ref;
        }
        if ((port = u.getPort()) == -1) {
            port = this.getDefaultPort();
        }
        this.setURL(u, "smb", u.getHost(), port, u.getAuthority(), u.getUserInfo(), (String)path, u.getQuery(), null);
    }
}

