/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import org.codelibs.jcifs.smb1.Config;
import org.codelibs.jcifs.smb1.SmbComTransaction;
import org.codelibs.jcifs.smb1.SmbComTransactionResponse;

public class BufferCache {
    private static final int MAX_BUFFERS = Config.getInt("jcifs.maxBuffers", 16);
    static Object[] cache = new Object[MAX_BUFFERS];
    private static int freeBuffers = 0;

    private BufferCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBuffer() {
        Object[] objectArray = cache;
        synchronized (cache) {
            if (freeBuffers > 0) {
                for (int i = 0; i < MAX_BUFFERS; ++i) {
                    if (cache[i] == null) continue;
                    byte[] buf = (byte[])cache[i];
                    BufferCache.cache[i] = null;
                    --freeBuffers;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return buf;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new byte[65535];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getBuffers(SmbComTransaction req, SmbComTransactionResponse rsp) {
        Object[] objectArray = cache;
        synchronized (cache) {
            req.txn_buf = BufferCache.getBuffer();
            rsp.txn_buf = BufferCache.getBuffer();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseBuffer(byte[] buf) {
        Object[] objectArray = cache;
        synchronized (cache) {
            if (freeBuffers < MAX_BUFFERS) {
                for (int i = 0; i < MAX_BUFFERS; ++i) {
                    if (cache[i] != null) continue;
                    BufferCache.cache[i] = buf;
                    ++freeBuffers;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

