/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.util;

import java.io.IOException;
import java.util.Date;

public final class Encdec {
    private static final long SEC_BETWEEEN_1904_AND_1970 = 2082844800L;
    private static final int TIME_1970_SEC_32BE = 1;
    private static final int TIME_1970_SEC_32LE = 2;
    private static final int TIME_1904_SEC_32BE = 3;
    private static final int TIME_1904_SEC_32LE = 4;
    private static final int TIME_1601_NANOS_64LE = 5;
    private static final int TIME_1601_NANOS_64BE = 6;
    private static final int TIME_1970_MILLIS_64BE = 7;
    private static final int TIME_1970_MILLIS_64LE = 8;

    private Encdec() {
    }

    public static int enc_uint16be(short s, byte[] dst, int di) {
        dst[di] = (byte)(s >> 8 & 0xFF);
        dst[++di] = (byte)(s & 0xFF);
        return 2;
    }

    public static int enc_uint32be(int i, byte[] dst, int di) {
        dst[di] = (byte)(i >> 24 & 0xFF);
        int n = ++di;
        dst[n] = (byte)(i >> 16 & 0xFF);
        int n2 = ++di;
        dst[n2] = (byte)(i >> 8 & 0xFF);
        dst[++di] = (byte)(i & 0xFF);
        return 4;
    }

    public static int enc_uint16le(short s, byte[] dst, int di) {
        dst[di] = (byte)(s & 0xFF);
        dst[++di] = (byte)(s >> 8 & 0xFF);
        return 2;
    }

    public static int enc_uint32le(int i, byte[] dst, int di) {
        dst[di] = (byte)(i & 0xFF);
        int n = ++di;
        dst[n] = (byte)(i >> 8 & 0xFF);
        int n2 = ++di;
        dst[n2] = (byte)(i >> 16 & 0xFF);
        dst[++di] = (byte)(i >> 24 & 0xFF);
        return 4;
    }

    public static short dec_uint16be(byte[] src, int si) {
        return (short)((src[si] & 0xFF) << 8 | src[si + 1] & 0xFF);
    }

    public static int dec_uint32be(byte[] src, int si) {
        return (src[si] & 0xFF) << 24 | (src[si + 1] & 0xFF) << 16 | (src[si + 2] & 0xFF) << 8 | src[si + 3] & 0xFF;
    }

    public static short dec_uint16le(byte[] src, int si) {
        return (short)(src[si] & 0xFF | (src[si + 1] & 0xFF) << 8);
    }

    public static int dec_uint32le(byte[] src, int si) {
        return src[si] & 0xFF | (src[si + 1] & 0xFF) << 8 | (src[si + 2] & 0xFF) << 16 | (src[si + 3] & 0xFF) << 24;
    }

    public static int enc_uint64be(long l, byte[] dst, int di) {
        Encdec.enc_uint32be((int)(l & 0xFFFFFFFFL), dst, di + 4);
        Encdec.enc_uint32be((int)(l >> 32 & 0xFFFFFFFFL), dst, di);
        return 8;
    }

    public static int enc_uint64le(long l, byte[] dst, int di) {
        Encdec.enc_uint32le((int)(l & 0xFFFFFFFFL), dst, di);
        Encdec.enc_uint32le((int)(l >> 32 & 0xFFFFFFFFL), dst, di + 4);
        return 8;
    }

    public static long dec_uint64be(byte[] src, int si) {
        long l = (long)Encdec.dec_uint32be(src, si) & 0xFFFFFFFFL;
        l <<= 32;
        return l |= (long)Encdec.dec_uint32be(src, si + 4) & 0xFFFFFFFFL;
    }

    public static long dec_uint64le(byte[] src, int si) {
        long l = (long)Encdec.dec_uint32le(src, si + 4) & 0xFFFFFFFFL;
        l <<= 32;
        return l |= (long)Encdec.dec_uint32le(src, si) & 0xFFFFFFFFL;
    }

    public static int enc_floatle(float f, byte[] dst, int di) {
        return Encdec.enc_uint32le(Float.floatToIntBits(f), dst, di);
    }

    public static int enc_floatbe(float f, byte[] dst, int di) {
        return Encdec.enc_uint32be(Float.floatToIntBits(f), dst, di);
    }

    public static float dec_floatle(byte[] src, int si) {
        return Float.intBitsToFloat(Encdec.dec_uint32le(src, si));
    }

    public static float dec_floatbe(byte[] src, int si) {
        return Float.intBitsToFloat(Encdec.dec_uint32be(src, si));
    }

    public static int enc_doublele(double d, byte[] dst, int di) {
        return Encdec.enc_uint64le(Double.doubleToLongBits(d), dst, di);
    }

    public static int enc_doublebe(double d, byte[] dst, int di) {
        return Encdec.enc_uint64be(Double.doubleToLongBits(d), dst, di);
    }

    public static double dec_doublele(byte[] src, int si) {
        return Double.longBitsToDouble(Encdec.dec_uint64le(src, si));
    }

    public static double dec_doublebe(byte[] src, int si) {
        return Double.longBitsToDouble(Encdec.dec_uint64be(src, si));
    }

    public static int enc_time(Date date, byte[] dst, int di, int enc) {
        return switch (enc) {
            case 1 -> Encdec.enc_uint32be((int)(date.getTime() / 1000L), dst, di);
            case 2 -> Encdec.enc_uint32le((int)(date.getTime() / 1000L), dst, di);
            case 3 -> Encdec.enc_uint32be((int)(date.getTime() / 1000L + 2082844800L & 0xFFFFFFFFFFFFFFFFL), dst, di);
            case 4 -> Encdec.enc_uint32le((int)(date.getTime() / 1000L + 2082844800L & 0xFFFFFFFFFFFFFFFFL), dst, di);
            case 6 -> {
                long t = (date.getTime() + 11644473600000L) * 10000L;
                yield Encdec.enc_uint64be(t, dst, di);
            }
            case 5 -> {
                long t = (date.getTime() + 11644473600000L) * 10000L;
                yield Encdec.enc_uint64le(t, dst, di);
            }
            case 7 -> Encdec.enc_uint64be(date.getTime(), dst, di);
            case 8 -> Encdec.enc_uint64le(date.getTime(), dst, di);
            default -> throw new IllegalArgumentException("Unsupported time encoding");
        };
    }

    public static Date dec_time(byte[] src, int si, int enc) {
        return switch (enc) {
            case 1 -> new Date((long)Encdec.dec_uint32be(src, si) * 1000L);
            case 2 -> new Date((long)Encdec.dec_uint32le(src, si) * 1000L);
            case 3 -> new Date((((long)Encdec.dec_uint32be(src, si) & 0xFFFFFFFFL) - 2082844800L) * 1000L);
            case 4 -> new Date((((long)Encdec.dec_uint32le(src, si) & 0xFFFFFFFFL) - 2082844800L) * 1000L);
            case 6 -> {
                long t = Encdec.dec_uint64be(src, si);
                yield new Date(t / 10000L - 11644473600000L);
            }
            case 5 -> {
                long t = Encdec.dec_uint64le(src, si);
                yield new Date(t / 10000L - 11644473600000L);
            }
            case 7 -> new Date(Encdec.dec_uint64be(src, si));
            case 8 -> new Date(Encdec.dec_uint64le(src, si));
            default -> throw new IllegalArgumentException("Unsupported time encoding");
        };
    }

    public static int enc_utf8(String str, byte[] dst, int di, int dlim) {
        int start = di;
        int strlen = str.length();
        for (int i = 0; di < dlim && i < strlen; ++i) {
            char ch = str.charAt(i);
            if (ch >= '\u0001' && ch <= '\u007f') {
                dst[di] = (byte)ch;
                ++di;
                continue;
            }
            if (ch > '\u07ff') {
                if (dlim - di < 3) break;
                dst[di] = (byte)(0xE0 | ch >> 12 & 0xF);
                int n = ++di;
                dst[n] = (byte)(0x80 | ch >> 6 & 0x3F);
            } else {
                if (dlim - di < 2) break;
                dst[di] = (byte)(0xC0 | ch >> 6 & 0x1F);
                ++di;
            }
            int n = ++di;
            ++di;
            dst[n] = (byte)(0x80 | ch >> 0 & 0x3F);
        }
        return di - start;
    }

    public static String dec_utf8(byte[] src, int si, int slim) throws IOException {
        int ch;
        char[] uni = new char[slim - si];
        int ui = 0;
        while (si < slim && (ch = src[si++] & 0xFF) != 0) {
            if (ch < 128) {
                uni[ui] = (char)ch;
            } else if ((ch & 0xE0) == 192) {
                if (slim - si < 2) break;
                uni[ui] = (char)((ch & 0x1F) << 6);
                ch = src[si] & 0xFF;
                ++si;
                int n = ui;
                uni[n] = (char)(uni[n] | ch & 0x3F);
                if ((ch & 0xC0) != 128 || uni[ui] < '\u0080') {
                    throw new IOException("Invalid UTF-8 sequence");
                }
            } else if ((ch & 0xF0) == 224) {
                if (slim - si < 3) break;
                uni[ui] = (char)((ch & 0xF) << 12);
                ch = src[si] & 0xFF;
                ++si;
                if ((ch & 0xC0) != 128) {
                    throw new IOException("Invalid UTF-8 sequence");
                }
                int n = ui;
                uni[n] = (char)(uni[n] | (ch & 0x3F) << 6);
                ch = src[si++] & 0xFF;
                int n2 = ui;
                uni[n2] = (char)(uni[n2] | ch & 0x3F);
                if ((ch & 0xC0) != 128 || uni[ui] < '\u0800') {
                    throw new IOException("Invalid UTF-8 sequence");
                }
            } else {
                throw new IOException("Unsupported UTF-8 sequence");
            }
            ++ui;
        }
        return new String(uni, 0, ui);
    }

    public static String dec_ucs2le(byte[] src, int si, int slim, char[] buf) {
        int bi = 0;
        while (si + 1 < slim) {
            buf[bi] = (char)Encdec.dec_uint16le(src, si);
            if (buf[bi] == '\u0000') break;
            ++bi;
            si += 2;
        }
        return new String(buf, 0, bi);
    }
}

