/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.pac.kerberos;

import java.io.IOException;
import javax.security.auth.kerberos.KerberosKey;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.codelibs.jcifs.smb.pac.ASN1Util;
import org.codelibs.jcifs.smb.pac.PACDecodingException;
import org.codelibs.jcifs.smb.pac.kerberos.KerberosApRequest;
import org.codelibs.jcifs.smb.pac.kerberos.KerberosTicket;

public class KerberosToken {
    private KerberosApRequest apRequest;

    public KerberosToken(byte[] token) throws PACDecodingException {
        this(token, null);
    }

    public KerberosToken(byte[] token, KerberosKey[] keys) throws PACDecodingException {
        byte[] content;
        ASN1InputStream stream;
        if (token.length <= 0) {
            throw new PACDecodingException("Empty kerberos token");
        }
        try {
            stream = new ASN1InputStream(token);
            try {
                content = ASN1Util.readUnparsedTagged(0, 32768, stream);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed kerberos token", e);
        }
        try {
            stream = new ASN1InputStream(content);
            try {
                ASN1ObjectIdentifier kerberosOid = (ASN1ObjectIdentifier)stream.readObject();
                if (!kerberosOid.getId().equals("1.2.840.113554.1.2.2")) {
                    throw new PACDecodingException("Not a kerberos token");
                }
                int readLow = stream.read() & 0xFF;
                int readHigh = stream.read() & 0xFF;
                int read = (readHigh << 8) + readLow;
                if (read != 1) {
                    throw new PACDecodingException("Malformed kerberos token");
                }
                ASN1TaggedObject mechToken = ASN1Util.as(ASN1TaggedObject.class, stream.readObject());
                if (mechToken == null || mechToken.getTagClass() != 64 || !(mechToken.getBaseObject() instanceof ASN1Sequence)) {
                    throw new PACDecodingException("Malformed kerberos token");
                }
                this.apRequest = new KerberosApRequest((ASN1Sequence)mechToken.getBaseObject(), keys);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed kerberos token", e);
        }
    }

    public KerberosTicket getTicket() {
        return this.apRequest.getTicket();
    }

    public KerberosApRequest getApRequest() {
        return this.apRequest;
    }
}

