/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.pac.kerberos;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.security.auth.kerberos.KerberosKey;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.codelibs.jcifs.smb.pac.ASN1Util;
import org.codelibs.jcifs.smb.pac.PACDecodingException;
import org.codelibs.jcifs.smb.pac.kerberos.KerberosAuthData;

public class KerberosRelevantAuthData
extends KerberosAuthData {
    private List<KerberosAuthData> authorizations;

    public KerberosRelevantAuthData(byte[] token, Map<Integer, KerberosKey> keys) throws PACDecodingException {
        ASN1Sequence authSequence;
        try (ASN1InputStream stream = new ASN1InputStream((InputStream)new ByteArrayInputStream(token));){
            authSequence = ASN1Util.as(ASN1Sequence.class, stream);
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed kerberos ticket", e);
        }
        this.authorizations = new ArrayList<KerberosAuthData>();
        Enumeration authElements = authSequence.getObjects();
        while (authElements.hasMoreElements()) {
            ASN1Sequence authElement = ASN1Util.as(ASN1Sequence.class, authElements);
            ASN1Integer authType = ASN1Util.as(ASN1Integer.class, ASN1Util.as(ASN1TaggedObject.class, authElement, 0));
            DEROctetString authData = ASN1Util.as(DEROctetString.class, ASN1Util.as(ASN1TaggedObject.class, authElement, 1));
            this.authorizations.addAll(KerberosAuthData.parse(authType.getValue().intValue(), authData.getOctets(), keys));
        }
    }

    public List<KerberosAuthData> getAuthorizations() {
        return this.authorizations;
    }
}

