/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.pac;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.kerberos.KerberosKey;
import org.codelibs.jcifs.smb.pac.PACDecodingException;

public class PacMac {
    private static final String HMAC_KEY = "HMAC";
    private static final byte[] MD5_CONSTANT = "signaturekey\u0000".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ZERO_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private PacMac() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] calculateMacArcfourHMACMD5(int keyusage, Key key, byte[] data) throws GeneralSecurityException {
        int ms_usage = PacMac.mapArcfourMD5KeyUsage(keyusage);
        Mac mac = Mac.getInstance("HmacMD5");
        MessageDigest md = MessageDigest.getInstance("MD5");
        mac.init(key);
        byte[] dk = mac.doFinal(MD5_CONSTANT);
        try {
            md.update((byte)(ms_usage & 0xFF));
            md.update((byte)(ms_usage >> 8 & 0xFF));
            md.update((byte)(ms_usage >> 16 & 0xFF));
            md.update((byte)(ms_usage >> 24 & 0xFF));
            byte[] dgst = md.digest(data);
            mac.reset();
            mac.init(new SecretKeySpec(dk, HMAC_KEY));
            byte[] byArray = mac.doFinal(dgst);
            return byArray;
        }
        finally {
            Arrays.fill(dk, 0, dk.length, (byte)0);
        }
    }

    private static int mapArcfourMD5KeyUsage(int keyusage) {
        int ms_usage = keyusage;
        switch (ms_usage) {
            case 3: {
                ms_usage = 8;
            }
            case 9: {
                ms_usage = 8;
            }
            case 23: {
                ms_usage = 13;
            }
        }
        return ms_usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] calculateMacHMACAES(int usage, KerberosKey baseKey, byte[] input) throws GeneralSecurityException {
        byte[] cst = new byte[]{(byte)(usage >> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), -103};
        byte[] output = new byte[12];
        byte[] dk = PacMac.deriveKeyAES(baseKey, cst);
        try {
            Mac m = Mac.getInstance("HmacSHA1");
            m.init(new SecretKeySpec(dk, HMAC_KEY));
            System.arraycopy(m.doFinal(input), 0, output, 0, 12);
            byte[] byArray = output;
            return byArray;
        }
        finally {
            Arrays.fill(dk, 0, dk.length, (byte)0);
        }
    }

    public static byte[] deriveKeyAES(KerberosKey key, byte[] constant) throws GeneralSecurityException {
        int len;
        byte[] keybytes = key.getEncoded();
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(1, (Key)new SecretKeySpec(keybytes, "AES"), new IvParameterSpec(ZERO_IV, 0, ZERO_IV.length));
        if (constant.length != cipher.getBlockSize()) {
            constant = PacMac.expandNFold(constant, cipher.getBlockSize());
        }
        byte[] enc = constant;
        int klen = keybytes.length;
        byte[] dk = new byte[klen];
        for (int n = 0; n < klen; n += len) {
            byte[] block = cipher.doFinal(enc);
            len = Math.min(klen - n, block.length);
            System.arraycopy(block, 0, dk, n, len);
            enc = block;
        }
        return dk;
    }

    public static byte[] expandNFold(byte[] data, int outlen) {
        int i;
        int lcm = PacMac.lcm(outlen, data.length);
        byte[] buf = new byte[outlen];
        int carry = 0;
        for (i = lcm - 1; i >= 0; --i) {
            carry = PacMac.carry_add(data, buf, carry, i);
        }
        if (carry != 0) {
            for (i = outlen - 1; i >= 0; --i) {
                buf[i] = (byte)((carry += buf[i] & 0xFF) & 0xFF);
                carry >>>= 8;
            }
        }
        return buf;
    }

    private static int carry_add(byte[] data, byte[] out, int c, int i) {
        int ilen = data.length;
        int olen = out.length;
        int msbit = ((ilen << 3) - 1 + ((ilen << 3) + 13) * (i / ilen) + (ilen - i % ilen << 3)) % (ilen << 3);
        int mshigh = msbit >>> 3;
        int mslow = msbit & 7;
        int b = c + (out[i % olen] & 0xFF) + (((data[(ilen - 1 - mshigh) % ilen] & 0xFF) << 8 | data[(ilen - mshigh) % ilen] & 0xFF) >>> mslow + 1 & 0xFF);
        out[i % olen] = (byte)(b & 0xFF);
        return b >>>= 8;
    }

    private static int lcm(int u, int v) {
        int a = u;
        int b = v;
        while (b != 0) {
            int c = b;
            b = a % b;
            a = c;
        }
        return u * v / a;
    }

    public static byte[] calculateMac(int type, Map<Integer, KerberosKey> keys, byte[] data) throws PACDecodingException {
        try {
            KerberosKey key;
            int usage = 17;
            if (type == -138) {
                KerberosKey key2 = keys.get(23);
                if (key2 == null) {
                    throw new PACDecodingException("Missing key");
                }
                return PacMac.calculateMacArcfourHMACMD5(usage, key2, data);
            }
            if (type != 15 && type != 16) {
                throw new PACDecodingException("Invalid MAC algorithm");
            }
            KerberosKey kerberosKey = key = type == 15 ? keys.get(17) : keys.get(18);
            if (key == null) {
                throw new PACDecodingException("Missing key");
            }
            return PacMac.calculateMacHMACAES(usage, key, data);
        }
        catch (GeneralSecurityException e) {
            throw new PACDecodingException("Failed to calculate MAC", e);
        }
    }
}

