/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.netbios;

import java.io.IOException;
import java.io.InputStream;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.NetbiosName;
import org.codelibs.jcifs.smb.netbios.Name;
import org.codelibs.jcifs.smb.netbios.SessionServicePacket;

public class SessionRequestPacket
extends SessionServicePacket {
    private final Name calledName;
    private final Name callingName;

    SessionRequestPacket(Configuration config) {
        this.calledName = new Name(config);
        this.callingName = new Name(config);
    }

    public SessionRequestPacket(Configuration config, NetbiosName calledName, NetbiosName callingName) {
        this.type = 129;
        this.calledName = new Name(config, calledName);
        this.callingName = new Name(config, callingName);
    }

    @Override
    int writeTrailerWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dstIndex += this.calledName.writeWireFormat(dst, dstIndex);
        dstIndex += this.callingName.writeWireFormat(dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    int readTrailerWireFormat(InputStream in, byte[] buffer, int bufferIndex) throws IOException {
        int start = bufferIndex;
        if (in.read(buffer, bufferIndex, this.length) != this.length) {
            throw new IOException("invalid session request wire format");
        }
        bufferIndex += this.calledName.readWireFormat(buffer, bufferIndex);
        bufferIndex += this.callingName.readWireFormat(buffer, bufferIndex);
        return bufferIndex - start;
    }
}

