/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.netbios;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.codelibs.jcifs.smb.Address;
import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.NetbiosAddress;
import org.codelibs.jcifs.smb.NetbiosName;
import org.codelibs.jcifs.smb.netbios.Name;

public final class NbtAddress
implements NetbiosAddress {
    public static final String ANY_HOSTS_NAME = "*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    public static final String MASTER_BROWSER_NAME = "\u0001\u0002__MSBROWSE__\u0002";
    public static final String SMBSERVER_NAME = "*SMBSERVER     ";
    public static final int B_NODE = 0;
    public static final int P_NODE = 1;
    public static final int M_NODE = 2;
    public static final int H_NODE = 3;
    public static final byte[] UNKNOWN_MAC_ADDRESS = new byte[]{0, 0, 0, 0, 0, 0};
    Name hostName;
    int address;
    int nodeType;
    boolean groupName;
    boolean isBeingDeleted;
    boolean isInConflict;
    boolean isActive;
    boolean isPermanent;
    boolean isDataFromNodeStatus;
    byte[] macAddress;
    String calledName;

    NbtAddress(Name hostName, int address, boolean groupName, int nodeType) {
        this.hostName = hostName;
        this.address = address;
        this.groupName = groupName;
        this.nodeType = nodeType;
    }

    NbtAddress(Name hostName, int address, boolean groupName, int nodeType, boolean isBeingDeleted, boolean isInConflict, boolean isActive, boolean isPermanent, byte[] macAddress) {
        this.hostName = hostName;
        this.address = address;
        this.groupName = groupName;
        this.nodeType = nodeType;
        this.isBeingDeleted = isBeingDeleted;
        this.isInConflict = isInConflict;
        this.isActive = isActive;
        this.isPermanent = isPermanent;
        this.macAddress = macAddress;
        this.isDataFromNodeStatus = true;
    }

    @Override
    public <T extends Address> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public String firstCalledName() {
        this.calledName = this.hostName.name;
        if (Character.isDigit(this.calledName.charAt(0))) {
            int dots = 0;
            int i = 0;
            int len = this.calledName.length();
            char[] data = this.calledName.toCharArray();
            while (i < len && Character.isDigit(data[i++])) {
                if (i == len && dots == 3) {
                    this.calledName = SMBSERVER_NAME;
                    break;
                }
                if (i >= len || data[i] != '.') continue;
                ++dots;
                ++i;
            }
        } else {
            switch (this.hostName.hexCode) {
                case 27: 
                case 28: 
                case 29: {
                    this.calledName = SMBSERVER_NAME;
                }
            }
        }
        return this.calledName;
    }

    @Override
    public String nextCalledName(CIFSContext tc) {
        if (this.calledName == this.hostName.name) {
            this.calledName = SMBSERVER_NAME;
        } else if (SMBSERVER_NAME.equals(this.calledName)) {
            try {
                NetbiosAddress[] addrs = tc.getNameServiceClient().getNodeStatus(this);
                if (this.getNameType() == 29) {
                    for (NetbiosAddress addr : addrs) {
                        if (addr.getNameType() != 32) continue;
                        return addr.getHostName();
                    }
                    return null;
                }
                if (this.isDataFromNodeStatus) {
                    this.calledName = null;
                    return this.getHostName();
                }
            }
            catch (UnknownHostException uhe) {
                this.calledName = null;
            }
        } else {
            this.calledName = null;
        }
        return this.calledName;
    }

    void checkData(CIFSContext tc) throws UnknownHostException {
        if (this.hostName.isUnknown()) {
            tc.getNameServiceClient().getNbtAllByAddress(this);
        }
    }

    void checkNodeStatusData(CIFSContext tc) throws UnknownHostException {
        if (!this.isDataFromNodeStatus) {
            tc.getNameServiceClient().getNbtAllByAddress(this);
        }
    }

    @Override
    public boolean isGroupAddress(CIFSContext tc) throws UnknownHostException {
        this.checkData(tc);
        return this.groupName;
    }

    @Override
    public int getNodeType(CIFSContext tc) throws UnknownHostException {
        this.checkData(tc);
        return this.nodeType;
    }

    @Override
    public boolean isBeingDeleted(CIFSContext tc) throws UnknownHostException {
        this.checkNodeStatusData(tc);
        return this.isBeingDeleted;
    }

    @Override
    public boolean isInConflict(CIFSContext tc) throws UnknownHostException {
        this.checkNodeStatusData(tc);
        return this.isInConflict;
    }

    @Override
    public boolean isActive(CIFSContext tc) throws UnknownHostException {
        this.checkNodeStatusData(tc);
        return this.isActive;
    }

    @Override
    public boolean isPermanent(CIFSContext tc) throws UnknownHostException {
        this.checkNodeStatusData(tc);
        return this.isPermanent;
    }

    @Override
    public byte[] getMacAddress(CIFSContext tc) throws UnknownHostException {
        this.checkNodeStatusData(tc);
        return this.macAddress;
    }

    @Override
    public String getHostName() {
        if (this.hostName.isUnknown()) {
            return this.getHostAddress();
        }
        return this.hostName.name;
    }

    @Override
    public NetbiosName getName() {
        return this.hostName;
    }

    public byte[] getAddress() {
        byte[] addr = new byte[]{(byte)(this.address >>> 24 & 0xFF), (byte)(this.address >>> 16 & 0xFF), (byte)(this.address >>> 8 & 0xFF), (byte)(this.address & 0xFF)};
        return addr;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.getHostAddress());
    }

    @Override
    public InetAddress toInetAddress() throws UnknownHostException {
        return this.getInetAddress();
    }

    @Override
    public String getHostAddress() {
        return (this.address >>> 24 & 0xFF) + "." + (this.address >>> 16 & 0xFF) + "." + (this.address >>> 8 & 0xFF) + "." + (this.address >>> 0 & 0xFF);
    }

    @Override
    public int getNameType() {
        return this.hostName.hexCode;
    }

    public int hashCode() {
        return this.address;
    }

    public boolean equals(Object obj) {
        return obj instanceof NbtAddress && ((NbtAddress)obj).address == this.address;
    }

    public String toString() {
        return this.hostName.toString() + "/" + this.getHostAddress();
    }
}

