/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.session;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockRequest;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Response;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class Smb2SessionSetupResponse
extends ServerMessageBlock2Response {
    public static final int SMB2_SESSION_FLAGS_IS_GUEST = 1;
    public static final int SMB2_SESSION_FLAGS_IS_NULL = 2;
    public static final int SMB2_SESSION_FLAG_ENCRYPT_DATA = 4;
    private int sessionFlags;
    private byte[] blob;

    public Smb2SessionSetupResponse(Configuration config) {
        super(config);
    }

    @Override
    public void prepare(CommonServerMessageBlockRequest next) {
        if (this.isReceived()) {
            next.setSessionId(this.getSessionId());
        }
        super.prepare(next);
    }

    @Override
    protected boolean isErrorResponseStatus() {
        return this.getStatus() != -1073741802 && super.isErrorResponseStatus();
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 9) {
            throw new SMBProtocolDecodingException("Structure size != 9");
        }
        this.sessionFlags = SMBUtil.readInt2(buffer, bufferIndex + 2);
        int securityBufferOffset = SMBUtil.readInt2(buffer, bufferIndex += 4);
        int securityBufferLength = SMBUtil.readInt2(buffer, bufferIndex + 2);
        int pad = (bufferIndex += 4) - (this.getHeaderStart() + securityBufferOffset);
        this.blob = new byte[securityBufferLength];
        System.arraycopy(buffer, this.getHeaderStart() + securityBufferOffset, this.blob, 0, securityBufferLength);
        bufferIndex += pad;
        return (bufferIndex += securityBufferLength) - start;
    }

    public boolean isLoggedInAsGuest() {
        return (this.sessionFlags & 3) != 0;
    }

    public int getSessionFlags() {
        return this.sessionFlags;
    }

    public byte[] getBlob() {
        return this.blob;
    }
}

